/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.hypertable.hadoop.mapreduce.KeyWritable;
import org.hypertable.hadoop.mapreduce.OutputFormat;
import org.hypertable.thriftgen.MutatorFlag;

public class LoadTest {
    private static final Log log = LogFactory.getLog(LoadTest.class);
    private int totalRows = 0;
    private int clients = 1;

    private void doMapReduce() {
        try {
            Job job = new Job();
            job.getConfiguration().set("hypertable.mapreduce.output.namespace", "/");
            job.getConfiguration().set("hypertable.mapreduce.output.table", "LoadTest");
            job.getConfiguration().setInt("hypertable.mapreduce.output.mutator-flags", MutatorFlag.NO_LOG_SYNC.getValue());
            job.getConfiguration().setInt("hypertable.mapreduce.output.mutator-flush-interval", 0);
            job.getConfiguration().setInt("LoadSplit.TOTAL_ROWS", this.totalRows);
            job.getConfiguration().setInt("LoadSplit.CLIENTS", this.clients);
            job.setJarByClass(LoadTest.class);
            job.setJobName("Hypertable MapReduce connector LoadTest");
            job.setInputFormatClass(LoadInputFormat.class);
            job.setOutputFormatClass(OutputFormat.class);
            job.setMapOutputKeyClass(KeyWritable.class);
            job.setMapOutputValueClass(BytesWritable.class);
            job.setMapperClass(LoadMapper.class);
            job.setReducerClass(LoadReducer.class);
            job.setNumReduceTasks(this.clients);
            job.waitForCompletion(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int run(String[] args) {
        String rows = "--rows=";
        String clients = "--clients=";
        try {
            for (int ii = 0; ii < args.length; ++ii) {
                String cmd = args[ii];
                if (cmd.startsWith(rows)) {
                    this.totalRows = Integer.parseInt(cmd.substring(rows.length()));
                    continue;
                }
                if (cmd.startsWith(clients)) {
                    this.clients = Integer.parseInt(cmd.substring(clients.length()));
                    continue;
                }
                this.printUsage();
                return -1;
            }
            this.doMapReduce();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    private void printUsage() {
        System.err.println("Usage: java " + this.getClass().getName() + " --rows=N");
    }

    public static void main(String[] args) throws Exception {
        LoadTest test = new LoadTest();
        System.exit(test.run(args));
    }

    public static class LoadReducer
    extends Reducer<KeyWritable, BytesWritable, KeyWritable, BytesWritable> {
        public void reduce(KeyWritable key, Iterable<BytesWritable> values, Reducer.Context ctx) throws IOException, InterruptedException {
            for (BytesWritable value : values) {
                long startTime = System.currentTimeMillis();
                ctx.write((Object)key, (Object)value);
                long elapsedTime = System.currentTimeMillis() - startTime;
                ctx.getCounter((Enum)Counters.ELAPSED_TIME_MS).increment(elapsedTime);
                ctx.getCounter((Enum)Counters.NUM_CELLS).increment(1L);
            }
        }

        static enum Counters {
            NUM_CELLS,
            ELAPSED_TIME_MS;

        }
    }

    public static class LoadMapper
    extends Mapper<NullWritable, LoadSplit, KeyWritable, BytesWritable> {
        public void map(NullWritable key, LoadSplit value, Mapper.Context ctx) throws IOException, InterruptedException {
            int startRow = value.getStartRow();
            int endRow = value.getNumRows() + startRow;
            int id = value.getSplitId();
            for (int ii = startRow; ii < endRow; ++ii) {
                KeyWritable output_key = new KeyWritable();
                BytesWritable output_value = new BytesWritable(Integer.toString(ii).getBytes());
                output_key.row = Integer.toString(ii);
                output_key.column_family = "col";
                ctx.write((Object)output_key, (Object)output_value);
                ctx.getCounter((Enum)Counters.NUM_CELLS).increment(1L);
                log.info((Object)("Mapper" + Integer.toString(id) + "created cell " + Integer.toString(ii)));
            }
        }

        static enum Counters {
            NUM_CELLS;

        }
    }

    public static class LoadRecordReader
    extends RecordReader<NullWritable, LoadSplit> {
        private LoadSplit split = null;
        private NullWritable key = null;
        private LoadSplit value = null;
        private boolean finished = false;

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.split = (LoadSplit)split;
            this.finished = false;
        }

        public boolean nextKeyValue() {
            if (this.finished) {
                return false;
            }
            this.key = NullWritable.get();
            this.value = this.split;
            this.finished = true;
            return true;
        }

        public NullWritable getCurrentKey() {
            return this.key;
        }

        public LoadSplit getCurrentValue() {
            return this.value;
        }

        public float getProgress() {
            if (this.finished) {
                return 1.0f;
            }
            return 0.0f;
        }

        public void close() {
        }
    }

    public static class LoadInputFormat
    extends InputFormat<NullWritable, LoadSplit> {
        public List<InputSplit> getSplits(JobContext job) throws IOException {
            ArrayList<InputSplit> splitList = new ArrayList<InputSplit>();
            int totalRows = job.getConfiguration().getInt("LoadSplit.TOTAL_ROWS", 0);
            int clients = job.getConfiguration().getInt("LoadSplit.CLIENTS", 1);
            int numRows = totalRows / clients;
            for (int ii = 0; ii < clients; ++ii) {
                int startRow = ii * numRows;
                LoadSplit split = new LoadSplit(startRow, numRows, ii);
                splitList.add(split);
            }
            return splitList;
        }

        public RecordReader<NullWritable, LoadSplit> createRecordReader(InputSplit split, TaskAttemptContext context) {
            return new LoadRecordReader();
        }
    }

    public static class LoadSplit
    extends InputSplit
    implements Writable {
        private int startRow = 0;
        private int numRows = 0;
        private int splitId = 0;

        public LoadSplit() {
            this.startRow = 0;
            this.numRows = 0;
            this.splitId = 0;
        }

        public LoadSplit(int startRow, int numRows, int splitId) {
            this.startRow = startRow;
            this.numRows = numRows;
            this.splitId = splitId;
        }

        public void readFields(DataInput in) throws IOException {
            this.startRow = in.readInt();
            this.numRows = in.readInt();
            this.splitId = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.startRow);
            out.writeInt(this.numRows);
            out.writeInt(this.splitId);
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public long getLength() throws IOException, InterruptedException {
            return 0L;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getNumRows() {
            return this.numRows;
        }

        public int getSplitId() {
            return this.splitId;
        }
    }
}

