/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples.PerformanceTest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.hypertable.AsyncComm.Comm;
import org.hypertable.AsyncComm.CommBuf;
import org.hypertable.AsyncComm.CommHeader;
import org.hypertable.AsyncComm.DispatchHandler;
import org.hypertable.AsyncComm.Event;
import org.hypertable.AsyncComm.ReactorFactory;
import org.hypertable.Common.Error;
import org.hypertable.Common.HypertableException;
import org.hypertable.Common.Usage;
import org.hypertable.examples.PerformanceTest.Driver;
import org.hypertable.examples.PerformanceTest.DriverCommon;
import org.hypertable.examples.PerformanceTest.DriverHBase;
import org.hypertable.examples.PerformanceTest.DriverHypertable;
import org.hypertable.examples.PerformanceTest.Message;
import org.hypertable.examples.PerformanceTest.MessageError;
import org.hypertable.examples.PerformanceTest.MessageFactory;
import org.hypertable.examples.PerformanceTest.MessageRegister;
import org.hypertable.examples.PerformanceTest.MessageSetup;
import org.hypertable.examples.PerformanceTest.MessageSummary;
import org.hypertable.examples.PerformanceTest.MessageTask;
import org.hypertable.examples.PerformanceTest.Setup;

public class Client {
    static final Logger log = Logger.getLogger("org.hypertable.examples.PerformanceTest");
    static String[] usage = new String[]{"", "usage: Client [OPTIONS] <host>[:<port>]", "", "OPTIONS:", "  --thriftbroker-port=<n>  Specifies the ThriftBroker port", "  --timeout=<t>            Specifies the connection timeout value", "  --reactors=<n>           Specifies the number of reactors", "", "This program is part of a performance test suite.  It acts as a single client", "supplying load to a Bigtable cluster and gets work from a dispatcher process.", "The dispatcher process is identified by the <host> and <port> arguments given", "on the command line", "", null};
    static boolean msShutdown = false;
    static final int DEFAULT_PORT = 11256;
    public static InetSocketAddress mDispatcherAddr;
    public static Comm mComm;
    public static ResponseHandler mRespHandler;

    private static String getPid() throws IOException {
        byte[] bo = new byte[100];
        String[] cmd = new String[]{"bash", "-c", "echo $PPID"};
        Process p = Runtime.getRuntime().exec(cmd);
        p.getInputStream().read(bo);
        return new String(bo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException, IOException {
        int i;
        Integer waitObj = new Integer(0);
        int port = 11256;
        int thriftbroker_port = 38080;
        String host = null;
        long timeout = 0L;
        if (args.length == 0) {
            i = 0;
            while (usage[i] != null) {
                System.out.println(usage[i]);
                ++i;
            }
            System.exit(0);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--timeout=")) {
                timeout = Integer.parseInt(args[i].substring(10));
            }
            if (args[i].startsWith("--thriftbroker-port=")) {
                thriftbroker_port = Integer.parseInt(args[i].substring(20));
                continue;
            }
            if (host == null) {
                int colon = args[i].indexOf(58);
                if (colon == -1) {
                    host = args[i];
                    continue;
                }
                host = args[i].substring(0, colon);
                port = Integer.parseInt(args[i].substring(colon + 1));
                continue;
            }
            Usage.DumpAndExit((String[])usage);
        }
        System.out.println("Connecting to " + host + ":" + port);
        try {
            Driver driver = null;
            CommHeader header = new CommHeader();
            Message messageReady = new Message(Message.Type.READY);
            MessageRegister messageRegister = new MessageRegister();
            String clientName = null;
            ReactorFactory.Initialize((short)1);
            mDispatcherAddr = new InetSocketAddress(host, port);
            mComm = new Comm(0);
            mRespHandler = new ResponseHandler();
            while (true) {
                mRespHandler.clearState();
                int error = mComm.Connect(mDispatcherAddr, timeout, (DispatchHandler)mRespHandler);
                if (error != 0) {
                    System.err.println("Connect error : " + Error.GetText((int)error));
                    System.exit(1);
                }
                if (mRespHandler.WaitForConnection()) break;
                System.out.println("Unable to connect to test dispatcher, will try again in 3 seconds...");
                Integer n = waitObj;
                synchronized (n) {
                    waitObj.wait(3000L);
                }
            }
            messageRegister.setHostName(InetAddress.getLocalHost().getHostName());
            messageRegister.setHostAddress(InetAddress.getLocalHost().getHostAddress());
            clientName = InetAddress.getLocalHost() + "-" + Client.getPid();
            messageRegister.setClientName(clientName);
            CommBuf cbuf = messageRegister.createCommBuf(header);
            Client.SendRequest(cbuf);
            Event event = mRespHandler.GetResponse();
            if (event == null) {
                throw new HypertableException(65539, "Receiving SETUP message");
            }
            Message message = MessageFactory.createMessage(event.payload);
            System.out.println(message);
            if (message.type() != Message.Type.SETUP) {
                throw new HypertableException(-1, "Expected SETUP message");
            }
            Setup setup = ((MessageSetup)message).setup;
            DriverCommon.VALUE_DATA_FILE = setup.valueData;
            if (setup.driver.equals("hypertable")) {
                driver = new DriverHypertable(thriftbroker_port);
            } else if (setup.driver.equals("hbase")) {
                driver = new DriverHBase();
            } else {
                MessageError messageError = new MessageError("Unrecognized driver: " + setup.driver);
                cbuf = messageError.createCommBuf(header);
                Client.SendRequest(cbuf);
                Integer n = waitObj;
                synchronized (n) {
                    waitObj.wait(5000L);
                }
                ReactorFactory.Shutdown();
                System.exit(1);
            }
            driver.setup(setup);
            cbuf = messageReady.createCommBuf(header);
            Client.SendRequest(cbuf);
            while ((event = mRespHandler.GetResponse()) != null) {
                message = MessageFactory.createMessage(event.payload);
                if (message.type() == Message.Type.TASK) {
                    driver.runTask(((MessageTask)message).task);
                    System.out.println(message);
                } else {
                    if (message.type() == Message.Type.FINISHED) {
                        driver.teardown();
                        MessageSummary messageSummary = new MessageSummary(clientName, driver.getResult());
                        cbuf = messageSummary.createCommBuf(header);
                        Client.SendRequest(cbuf);
                        System.out.println(message);
                        break;
                    }
                    System.out.println("error: message type " + message.type().ordinal());
                }
                cbuf = messageReady.createCommBuf(header);
                Client.SendRequest(cbuf);
            }
            Integer n = waitObj;
            synchronized (n) {
                waitObj.wait(5000L);
            }
            ReactorFactory.Shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void SendRequest(CommBuf cbuf) throws HypertableException, InterruptedException {
        int error;
        int retries = 0;
        while ((error = mComm.SendRequest(mDispatcherAddr, cbuf, (DispatchHandler)mRespHandler)) != 0) {
            if (error == 65537) {
                Integer waitObj;
                if (retries == 5) {
                    throw new HypertableException(65539, "timeout");
                }
                Integer n = waitObj = new Integer(0);
                synchronized (n) {
                    waitObj.wait(1000L);
                }
                ++retries;
                continue;
            }
            throw new HypertableException(error);
        }
    }

    static class ResponseHandler
    implements DispatchHandler {
        private LinkedList<Event> mQueue = new LinkedList();
        private State mState = State.IDLE;

        public void clearState() {
            this.mState = State.IDLE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(Event event) {
            ResponseHandler responseHandler = this;
            synchronized (responseHandler) {
                if (event.type == Event.Type.CONNECTION_ESTABLISHED) {
                    System.out.println("Connection Established.");
                    this.mState = State.CONNECTED;
                    this.notify();
                } else if (event.type == Event.Type.DISCONNECT) {
                    if (event.error != 65539) {
                        System.out.println("Disconnect.  " + Error.GetText((int)event.error));
                        System.exit(0);
                    }
                    this.mState = State.DISCONNECTED;
                    this.notify();
                } else if (event.type == Event.Type.ERROR) {
                    System.err.println("Error : " + Error.GetText((int)event.error));
                } else if (event.type == Event.Type.MESSAGE) {
                    Event newEvent = new Event(event);
                    this.mQueue.offer(newEvent);
                    this.notify();
                }
            }
        }

        public synchronized boolean WaitForConnection() throws InterruptedException {
            while (this.mState == State.IDLE) {
                this.wait();
            }
            return this.mState == State.CONNECTED;
        }

        public synchronized Event GetResponse() throws InterruptedException {
            while (this.mQueue.isEmpty()) {
                this.wait();
                if (this.mState == State.CONNECTED) continue;
                return null;
            }
            return this.mQueue.remove();
        }

        static enum State {
            IDLE,
            CONNECTED,
            DISCONNECTED;

        }
    }
}

