/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples.PerformanceTest;

import java.io.IOException;
import java.util.logging.Logger;
import org.hypertable.Common.DiscreteRandomGeneratorZipf;
import org.hypertable.examples.PerformanceTest.DriverCommon;
import org.hypertable.examples.PerformanceTest.Result;
import org.hypertable.examples.PerformanceTest.Setup;
import org.hypertable.examples.PerformanceTest.Task;

public abstract class Driver {
    static final Logger log = Logger.getLogger("org.hypertable.examples.PerformanceTest");
    protected Result mResult;
    protected DriverCommon mCommon = new DriverCommon();
    protected Setup mSetup;
    protected DiscreteRandomGeneratorZipf mZipf;
    protected long mZipfianMultiplier = 0L;

    public void setup(Setup setup) {
        this.mSetup = setup;
        this.mResult = new Result();
        try {
            if (this.mSetup.distribution == Setup.Distribution.ZIPFIAN) {
                if (this.mSetup.cmfFile != null || this.mSetup.cmfFile.equals("")) {
                    System.out.printf("Loading Zipfian CMF data from file " + this.mSetup.cmfFile, new Object[0]);
                    this.mZipf = new DiscreteRandomGeneratorZipf(this.mSetup.cmfFile);
                } else {
                    if (this.mSetup.distributionRange == 0L) {
                        System.out.println("Distribution range must be specified for Zipfian random distribution");
                        System.exit(-1);
                    }
                    this.mZipf = new DiscreteRandomGeneratorZipf(0, (int)this.mSetup.distributionRange, 1, 0.8);
                }
                this.mZipfianMultiplier = this.mSetup.keyMax / (long)this.mZipf.distributionRange();
                this.mZipf.setSeed(System.nanoTime());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected long getRandomLong() {
        return Math.abs(this.mCommon.random.nextLong());
    }

    public abstract void teardown();

    public abstract void runTask(Task var1) throws IOException;

    public Result getResult() {
        return this.mResult;
    }
}

