/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples.PerformanceTest;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;

public class DriverCommon {
    public static String VALUE_DATA_FILE;
    public static final String COLUMN_FAMILY = "column";
    public static final String COLUMN_QUALIFIER = "data";
    public static final String INCREMENT_VALUE = "1";
    public static final byte[] COLUMN_FAMILY_BYTES;
    public static final byte[] COLUMN_QUALIFIER_BYTES;
    public static final byte[] INCREMENT_VALUE_BYTES;
    protected Random random = new Random(System.nanoTime());
    protected static ByteBuffer valueData;

    public void initializeValueData() throws IOException {
        if (VALUE_DATA_FILE == null || VALUE_DATA_FILE.equals("")) {
            byte[] randomData = new byte[262144];
            this.random.nextBytes(randomData);
            valueData = ByteBuffer.wrap(randomData);
        } else {
            File file = new File(VALUE_DATA_FILE);
            FileChannel roChannel = new RandomAccessFile(file, "r").getChannel();
            valueData = roChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)roChannel.size());
        }
    }

    public void fillValueBuffer(byte[] value) {
        int randOffset = this.random.nextInt(valueData.capacity() - 2 * value.length);
        valueData.position(randOffset);
        valueData.get(value, 0, value.length);
    }

    public static String formatRowKey(long number, int digits) {
        StringBuilder str = new StringBuilder(digits + 1);
        long d = Math.abs(number);
        str.setLength(digits);
        for (int ii = digits - 1; ii >= 0; --ii) {
            str.setCharAt(ii, (char)(d % 10L + 48L));
            d /= 10L;
        }
        return str.toString();
    }

    public static void formatRowKey(long number, int digits, byte[] dest) {
        long d = Math.abs(number);
        for (int ii = digits - 1; ii >= 0; --ii) {
            dest[ii] = (byte)(d % 10L + 48L);
            d /= 10L;
        }
    }

    static {
        COLUMN_FAMILY_BYTES = COLUMN_FAMILY.getBytes();
        COLUMN_QUALIFIER_BYTES = COLUMN_QUALIFIER.getBytes();
        INCREMENT_VALUE_BYTES = INCREMENT_VALUE.getBytes();
    }
}

