/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples.PerformanceTest;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.hypertable.examples.PerformanceTest.Driver;
import org.hypertable.examples.PerformanceTest.DriverCommon;
import org.hypertable.examples.PerformanceTest.Setup;
import org.hypertable.examples.PerformanceTest.Task;

public class DriverHBase
extends Driver {
    static final Logger log = Logger.getLogger("org.hypertable.examples.PerformanceTest");
    protected volatile Configuration conf = HBaseConfiguration.create();
    protected HBaseAdmin admin = new HBaseAdmin(this.conf);
    protected HTable table;

    @Override
    public void setup(Setup setup) {
        super.setup(setup);
        try {
            this.table = new HTable(this.conf, this.mSetup.tableName);
            this.table.setAutoFlush(false);
            this.table.setWriteBufferSize(0xC00000L);
            if (this.mSetup.type == Setup.Type.WRITE) {
                this.mCommon.initializeValueData();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void teardown() {
    }

    @Override
    public void runTask(Task task) throws IOException {
        ByteBuffer keyByteBuf = ByteBuffer.allocate(8);
        byte[] keyBuf = keyByteBuf.array();
        KeyValue[] kvs = null;
        long taskStartTime = System.currentTimeMillis();
        if (this.mSetup.type == Setup.Type.WRITE) {
            Put put = null;
            byte[] value = null;
            try {
                for (long i = task.start; i < task.end; ++i) {
                    if (this.mSetup.order == Setup.Order.RANDOM) {
                        long randi = this.getRandomLong();
                        if (this.mSetup.keyMax != -1L) {
                            randi %= this.mSetup.keyMax;
                        }
                        put = new Put(DriverCommon.formatRowKey(randi, this.mSetup.keySize).getBytes());
                    } else {
                        put = new Put(DriverCommon.formatRowKey(i, this.mSetup.keySize).getBytes());
                    }
                    value = new byte[this.mSetup.valueSize];
                    this.mCommon.fillValueBuffer(value);
                    put.add(DriverCommon.COLUMN_FAMILY_BYTES, DriverCommon.COLUMN_QUALIFIER_BYTES, value);
                    this.table.put(put);
                }
                this.table.flushCommits();
            }
            catch (Exception e) {
                log.severe(e.toString());
                throw new IOException("Unable to set cell via thrift - " + e.toString());
            }
        } else if (this.mSetup.type == Setup.Type.READ) {
            Get get = null;
            Result result = null;
            try {
                for (long i = task.start; i < task.end; ++i) {
                    if (this.mSetup.order == Setup.Order.RANDOM) {
                        long randi;
                        keyByteBuf.clear();
                        if (this.mSetup.distribution == Setup.Distribution.ZIPFIAN) {
                            randi = this.mZipf.getSample();
                            randi *= this.mZipfianMultiplier;
                        } else {
                            randi = this.getRandomLong() % this.mSetup.keyMax;
                        }
                        get = new Get(DriverCommon.formatRowKey(randi, this.mSetup.keySize).getBytes());
                    } else {
                        get = new Get(DriverCommon.formatRowKey(i, this.mSetup.keySize).getBytes());
                    }
                    get.addColumn(DriverCommon.COLUMN_FAMILY_BYTES, DriverCommon.COLUMN_QUALIFIER_BYTES);
                    long startTime = System.currentTimeMillis();
                    result = this.table.get(get);
                    this.mResult.cumulativeLatency += System.currentTimeMillis() - startTime;
                    ++this.mResult.requestCount;
                    if (result == null || (kvs = result.raw()) == null) continue;
                    for (KeyValue kv : kvs) {
                        ++this.mResult.itemsReturned;
                        this.mResult.valueBytesReturned += (long)kv.getValueLength();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.severe(e.toString());
                throw new IOException("Unable to set KeyValue via thrift - " + e.toString());
            }
        } else if (this.mSetup.type == Setup.Type.SCAN) {
            Scan scan = new Scan(DriverCommon.formatRowKey(task.start, this.mSetup.keySize).getBytes(), DriverCommon.formatRowKey(task.end, this.mSetup.keySize).getBytes());
            scan.setMaxVersions();
            this.table.setScannerCaching(this.mSetup.scanBufferSize / (this.mSetup.keySize + 10 + this.mSetup.valueSize));
            ResultScanner scanner = this.table.getScanner(scan);
            Result result = null;
            result = scanner.next();
            while (result != null) {
                kvs = result.raw();
                if (kvs != null) {
                    for (KeyValue kv : kvs) {
                        ++this.mResult.itemsReturned;
                        this.mResult.valueBytesReturned += (long)kv.getValueLength();
                    }
                }
                result = scanner.next();
            }
            scanner.close();
        }
        this.mResult.itemsSubmitted += task.end - task.start;
        this.mResult.elapsedMillis += System.currentTimeMillis() - taskStartTime;
    }
}

