/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples.PerformanceTest;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.hypertable.examples.PerformanceTest.Driver;
import org.hypertable.examples.PerformanceTest.DriverCommon;
import org.hypertable.examples.PerformanceTest.DriverThreadHypertable;
import org.hypertable.examples.PerformanceTest.DriverThreadState;
import org.hypertable.examples.PerformanceTest.Setup;
import org.hypertable.examples.PerformanceTest.Task;
import org.hypertable.thrift.SerializedCellsReader;
import org.hypertable.thrift.SerializedCellsWriter;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.ClientException;
import org.hypertable.thriftgen.RowInterval;
import org.hypertable.thriftgen.ScanSpec;

public class DriverHypertable
extends Driver {
    static final Logger log = Logger.getLogger("org.hypertable.examples.PerformanceTest");
    public static final int CLIENT_BUFFER_SIZE = 0xC00000;
    public static final int DEFAULT_THRIFTBROKER_PORT = 38080;
    ThriftClient mClient;
    String mNamespace;
    long mMutator;
    long mNamespaceId = 0L;
    SerializedCellsWriter mCellsWriter;
    DriverThreadState[] mThreadStates;
    int mThreadNext = 0;
    int mThriftBrokerPort = 38080;

    public DriverHypertable() throws TTransportException, TException {
    }

    public DriverHypertable(int broker_port) {
        this.mThriftBrokerPort = broker_port;
    }

    protected void finalize() {
        if (this.mSetup.parallelism == 0) {
            try {
                if (this.mNamespaceId != 0L) {
                    this.mClient.namespace_close(this.mNamespaceId);
                }
            }
            catch (Exception e) {
                System.out.println("Unable to close namespace - " + this.mNamespace + e.getMessage());
                System.exit(-1);
            }
        }
    }

    @Override
    public void setup(Setup setup) {
        super.setup(setup);
        if (this.mSetup.parallelism == 0) {
            this.mCellsWriter = new SerializedCellsWriter(0xC00000);
            try {
                this.mClient = ThriftClient.create((String)"localhost", (int)this.mThriftBrokerPort);
                this.mNamespace = "/";
                this.mNamespaceId = this.mClient.namespace_open(this.mNamespace);
            }
            catch (Exception e) {
                System.out.println("Unable to establish connection to ThriftBroker at localhost:38080 and open namespace '/'- " + e.getMessage());
                System.exit(-1);
            }
        }
        try {
            this.mCommon.initializeValueData();
            if (this.mSetup.parallelism > 0) {
                this.mThreadStates = new DriverThreadState[this.mSetup.parallelism];
                for (int i = 0; i < this.mSetup.parallelism; ++i) {
                    this.mThreadStates[i] = new DriverThreadState();
                    this.mThreadStates[i].common = this.mCommon;
                    this.mThreadStates[i].thread = new DriverThreadHypertable("/", this.mSetup.tableName, this.mThreadStates[i]);
                    this.mThreadStates[i].thread.start();
                }
            } else {
                this.mCellsWriter.clear();
                if (this.mSetup.type == Setup.Type.WRITE || this.mSetup.type == Setup.Type.INCR) {
                    this.mMutator = this.mClient.mutator_open(this.mNamespaceId, this.mSetup.tableName, 0, 0);
                }
            }
        }
        catch (ClientException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        catch (TException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public void teardown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void runTask(Task task) throws IOException {
        keyByteBuf = ByteBuffer.allocate(8);
        keyBuf = keyByteBuf.array();
        taskStartTime = System.currentTimeMillis();
        if (this.mSetup.type == Setup.Type.WRITE) {
            row = new byte[this.mSetup.keySize];
            family = DriverCommon.COLUMN_FAMILY_BYTES;
            qualifier = DriverCommon.COLUMN_QUALIFIER_BYTES;
            value = new byte[this.mSetup.valueSize];
            if (this.mSetup.parallelism == 0) {
                this.mCellsWriter.clear();
            }
            try {
                for (i = task.start; i < task.end; ++i) {
                    if (this.mSetup.order == Setup.Order.RANDOM) {
                        randi = this.getRandomLong();
                        if (this.mSetup.keyMax != -1L) {
                            randi %= this.mSetup.keyMax;
                        }
                        DriverCommon.formatRowKey(randi, this.mSetup.keySize, row);
                    } else {
                        DriverCommon.formatRowKey(i, this.mSetup.keySize, row);
                    }
                    this.mCommon.fillValueBuffer(value);
                    if (this.mSetup.parallelism > 0) {
                        this.mCellsWriter = new SerializedCellsWriter(this.mSetup.keySize + family.length + qualifier.length + value.length + 32);
                        if (!this.mCellsWriter.add(row, 0, this.mSetup.keySize, family, 0, family.length, qualifier, 0, qualifier.length, -9223372036854775806L, value, 0, value.length, (byte)-1)) {
                            System.out.println("Failed to write to SerializedCellsWriter");
                            System.exit(-1);
                        }
                        var14_25 = this.mThreadStates[this.mThreadNext];
                        synchronized (var14_25) {
                            this.mThreadStates[this.mThreadNext].updates.add(this.mCellsWriter);
                            this.mThreadStates[this.mThreadNext].notifyAll();
                        }
                        this.mThreadNext = (this.mThreadNext + 1) % this.mSetup.parallelism;
                        this.mCellsWriter = null;
                        continue;
                    }
                    while (!this.mCellsWriter.add(row, 0, this.mSetup.keySize, family, 0, family.length, qualifier, 0, qualifier.length, -9223372036854775806L, value, 0, value.length, (byte)-1)) {
                        this.mClient.mutator_set_cells_serialized(this.mMutator, this.mCellsWriter.buffer(), false);
                        this.mCellsWriter.clear();
                    }
                }
                if (this.mSetup.parallelism != 0) ** GOTO lbl176
                if (!this.mCellsWriter.isEmpty()) {
                    this.mClient.mutator_set_cells_serialized(this.mMutator, this.mCellsWriter.buffer(), true);
                }
                this.mClient.mutator_flush(this.mMutator);
            }
            catch (Exception e) {
                e.printStackTrace();
                DriverHypertable.log.severe(e.toString());
                throw new IOException("Unable to set cell via thrift - " + e.toString());
            }
        } else if (this.mSetup.type == Setup.Type.INCR) {
            row = new byte[this.mSetup.keySize];
            family = DriverCommon.COLUMN_FAMILY_BYTES;
            qualifier = DriverCommon.COLUMN_QUALIFIER_BYTES;
            value = DriverCommon.INCREMENT_VALUE_BYTES;
            if (this.mSetup.parallelism == 0) {
                this.mCellsWriter.clear();
            }
            try {
                for (i = task.start; i < task.end; ++i) {
                    if (this.mSetup.order == Setup.Order.RANDOM) {
                        randi = this.getRandomLong();
                        if (this.mSetup.keyMax != -1L) {
                            randi %= this.mSetup.keyMax;
                        }
                        DriverCommon.formatRowKey(randi, this.mSetup.keySize, row);
                    } else {
                        DriverCommon.formatRowKey(i, this.mSetup.keySize, row);
                    }
                    if (this.mSetup.parallelism > 0) {
                        this.mCellsWriter = new SerializedCellsWriter(this.mSetup.keySize + family.length + qualifier.length + value.length + 32);
                        if (!this.mCellsWriter.add(row, 0, this.mSetup.keySize, family, 0, family.length, qualifier, 0, qualifier.length, -9223372036854775806L, value, 0, value.length, (byte)-1)) {
                            System.out.println("Failed to write to SerializedCellsWriter");
                            System.exit(-1);
                        }
                        var14_26 = this.mThreadStates[this.mThreadNext];
                        synchronized (var14_26) {
                            this.mThreadStates[this.mThreadNext].updates.add(this.mCellsWriter);
                            this.mThreadStates[this.mThreadNext].notifyAll();
                        }
                        this.mThreadNext = (this.mThreadNext + 1) % this.mSetup.parallelism;
                        this.mCellsWriter = null;
                        continue;
                    }
                    while (!this.mCellsWriter.add(row, 0, this.mSetup.keySize, family, 0, family.length, qualifier, 0, qualifier.length, -9223372036854775806L, value, 0, value.length, (byte)-1)) {
                        this.mClient.mutator_set_cells_serialized(this.mMutator, this.mCellsWriter.buffer(), false);
                        this.mCellsWriter.clear();
                    }
                }
                if (this.mSetup.parallelism != 0) ** GOTO lbl176
                if (!this.mCellsWriter.isEmpty()) {
                    this.mClient.mutator_set_cells_serialized(this.mMutator, this.mCellsWriter.buffer(), true);
                }
                this.mClient.mutator_flush(this.mMutator);
            }
            catch (Exception e) {
                e.printStackTrace();
                DriverHypertable.log.severe(e.toString());
                throw new IOException("Unable to set cell via thrift - " + e.toString());
            }
        } else {
            if (this.mSetup.type == Setup.Type.READ) {
                reader = new SerializedCellsReader(null);
                if (this.mSetup.parallelism != 0) {
                    System.out.println("Parallel reads not implemented");
                    System.exit(1);
                }
                try {
                    for (i = task.start; i < task.end; ++i) {
                        if (this.mSetup.order == Setup.Order.RANDOM) {
                            keyByteBuf.clear();
                            if (this.mSetup.distribution == Setup.Distribution.ZIPFIAN) {
                                randi = this.mZipf.getSample();
                                randi *= this.mZipfianMultiplier;
                            } else {
                                randi = this.getRandomLong() % this.mSetup.keyMax;
                            }
                            row = DriverCommon.formatRowKey(randi, this.mSetup.keySize);
                        } else {
                            row = DriverCommon.formatRowKey(i, this.mSetup.keySize);
                        }
                        startTime = System.currentTimeMillis();
                        reader.reset(this.mClient.get_row_serialized(this.mNamespaceId, this.mSetup.tableName, row));
                        this.mResult.cumulativeLatency += System.currentTimeMillis() - startTime;
                        ++this.mResult.requestCount;
                        while (reader.next()) {
                            ++this.mResult.itemsReturned;
                            this.mResult.valueBytesReturned += (long)reader.get_value_length();
                        }
                    }
                }
                catch (Exception e) {
                    DriverHypertable.log.severe(e.toString());
                    throw new IOException("Unable to set cell via thrift - " + e.toString());
                }
            }
            if (this.mSetup.type == Setup.Type.SCAN) {
                eos = false;
                start_row = DriverCommon.formatRowKey(task.start, this.mSetup.keySize);
                end_row = DriverCommon.formatRowKey(task.end, this.mSetup.keySize);
                reader = new SerializedCellsReader(null);
                if (this.mSetup.parallelism != 0) {
                    System.out.println("Parallel scans not implemented");
                    System.exit(1);
                }
                scan_spec = new ScanSpec();
                ri = new RowInterval();
                ri.setStart_row(start_row);
                ri.setStart_inclusive(true);
                ri.setEnd_row(end_row);
                ri.setEnd_inclusive(false);
                scan_spec.addToRow_intervals(ri);
                try {
                    scanner = this.mClient.scanner_open(this.mNamespaceId, this.mSetup.tableName, scan_spec);
                    while (!eos) {
                        reader.reset(this.mClient.scanner_get_cells_serialized(scanner));
                        while (reader.next()) {
                            ++this.mResult.itemsReturned;
                            this.mResult.valueBytesReturned += (long)reader.get_value_length();
                        }
                        eos = reader.eos();
                    }
                    this.mClient.scanner_close(scanner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Problem fetching scan results via thrift - " + e.toString());
                }
            }
        }
lbl176:
        // 10 sources

        try {
            for (i = 0; i < this.mSetup.parallelism; ++i) {
                var9_11 = this.mThreadStates[this.mThreadNext];
                synchronized (var9_11) {
                    if (!this.mThreadStates[this.mThreadNext].updates.isEmpty()) {
                        this.mThreadStates[this.mThreadNext].wait();
                    }
                    continue;
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.mResult.itemsSubmitted += task.end - task.start;
        this.mResult.elapsedMillis += System.currentTimeMillis() - taskStartTime;
    }
}

