/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples.PerformanceTest;

import java.util.logging.Logger;
import org.hypertable.examples.PerformanceTest.DriverThreadState;
import org.hypertable.thrift.SerializedCellsWriter;
import org.hypertable.thrift.ThriftClient;

public class DriverThreadHypertable
extends Thread {
    static final Logger log = Logger.getLogger("org.hypertable.examples.PerformanceTest");
    public static final int CLIENT_BUFFER_SIZE = 0xC00000;
    ThriftClient mClient;
    String mNamespace;
    String mTableName;
    long mMutator = 0L;
    long mNamespaceId = 0L;
    DriverThreadState mState;

    public DriverThreadHypertable(String namespace, String table, DriverThreadState state) {
        this.mTableName = table;
        this.mNamespace = namespace;
        this.mState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long wait_millis = this.mState.common.random.nextInt();
            wait_millis = wait_millis < 0L ? wait_millis * -1L % 2000L : (wait_millis %= 2000L);
            DriverThreadState driverThreadState = this.mState;
            synchronized (driverThreadState) {
                this.mState.wait(wait_millis);
            }
            this.mClient = ThriftClient.create((String)"localhost", (int)38080);
            this.mNamespaceId = this.mClient.open_namespace(this.mNamespace);
            this.mMutator = this.mClient.open_mutator(this.mNamespaceId, this.mTableName, 0, 0);
            driverThreadState = this.mState;
            synchronized (driverThreadState) {
                while (!this.mState.finished) {
                    this.mState.wait();
                    while (!this.mState.updates.isEmpty()) {
                        try {
                            SerializedCellsWriter writer = this.mState.updates.remove();
                            this.mClient.mutator_set_cells_serialized(this.mMutator, writer.buffer(), true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.mState.notifyAll();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

