/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples.PerformanceTest;

import java.nio.ByteBuffer;
import org.hypertable.AsyncComm.Serialization;
import org.hypertable.examples.PerformanceTest.Message;
import org.hypertable.examples.PerformanceTest.Result;

public class MessageSummary
extends Message {
    private String mClientName;
    private Result mResult;

    public MessageSummary() {
        super(Message.Type.SUMMARY);
    }

    public MessageSummary(String name, Result s) {
        super(Message.Type.SUMMARY);
        this.mClientName = name;
        this.mResult = s;
    }

    @Override
    public int encodedLength() {
        return Serialization.EncodedLengthString((String)this.mClientName) + this.mResult.encodedLength();
    }

    @Override
    public void encode(ByteBuffer buf) {
        Serialization.EncodeString((ByteBuffer)buf, (String)this.mClientName);
        this.mResult.encode(buf);
    }

    @Override
    public void decode(ByteBuffer buf) {
        this.mClientName = Serialization.DecodeString((ByteBuffer)buf);
        this.mResult = new Result();
        this.mResult.decode(buf);
    }

    @Override
    public String toString() {
        return new String("MESSAGE:SUMMARY { client=" + this.mClientName + ", result=" + this.mResult + " }");
    }

    public void setClientName(String name) {
        this.mClientName = name;
    }

    public String getClientName() {
        return this.mClientName;
    }

    public void setResult(Result result) {
        this.mResult = result;
    }

    public Result getResult() {
        return this.mResult;
    }
}

