/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples.PerformanceTest;

import java.nio.ByteBuffer;
import org.hypertable.AsyncComm.Serialization;

public class Setup {
    public Type type = Type.READ;
    public Order order = Order.SEQUENTIAL;
    public Distribution distribution = Distribution.UNIFORM;
    public long distributionRange = 0L;
    public long keyCount = -1L;
    public long keyMax = -1L;
    public int keySize = -1;
    public int valueSize = -1;
    public int scanBufferSize = 65536;
    public int parallelism = 0;
    public String tableName;
    public String driver;
    public String valueData;
    public String cmfFile;

    public int encodedLength() {
        return 52 + Serialization.EncodedLengthString((String)this.tableName) + Serialization.EncodedLengthString((String)this.driver) + Serialization.EncodedLengthString((String)this.valueData) + Serialization.EncodedLengthString((String)this.cmfFile);
    }

    public void encode(ByteBuffer buf) {
        buf.putInt(this.type.ordinal());
        buf.putLong(this.keyMax);
        buf.putInt(this.keySize);
        buf.putInt(this.valueSize);
        buf.putLong(this.keyCount);
        buf.putInt(this.order.ordinal());
        buf.putInt(this.distribution.ordinal());
        buf.putLong(this.distributionRange);
        buf.putInt(this.scanBufferSize);
        buf.putInt(this.parallelism);
        Serialization.EncodeString((ByteBuffer)buf, (String)this.tableName);
        Serialization.EncodeString((ByteBuffer)buf, (String)this.driver);
        Serialization.EncodeString((ByteBuffer)buf, (String)this.valueData);
        Serialization.EncodeString((ByteBuffer)buf, (String)this.cmfFile);
    }

    public void decode(ByteBuffer buf) {
        this.type = Type.values()[buf.getInt()];
        this.keyMax = buf.getLong();
        this.keySize = buf.getInt();
        this.valueSize = buf.getInt();
        this.keyCount = buf.getLong();
        this.order = Order.values()[buf.getInt()];
        this.distribution = Distribution.values()[buf.getInt()];
        this.distributionRange = buf.getLong();
        this.scanBufferSize = buf.getInt();
        this.parallelism = buf.getInt();
        this.tableName = Serialization.DecodeString((ByteBuffer)buf);
        this.driver = Serialization.DecodeString((ByteBuffer)buf);
        this.valueData = Serialization.DecodeString((ByteBuffer)buf);
        this.cmfFile = Serialization.DecodeString((ByteBuffer)buf);
    }

    public String toString() {
        return new String("type=" + (Object)((Object)this.type) + ", keyMax=" + this.keyMax + ", keySize=" + this.keySize + ", valueSize=" + this.valueSize + ", keyCount=" + this.keyCount + ", order=" + (Object)((Object)this.order) + ", distribution=" + (Object)((Object)this.distribution) + ", distributionRange=" + this.distributionRange + ", scanBufferSize=" + this.scanBufferSize + ", parallelism=" + this.parallelism + ", tableName=" + this.tableName + ", driver=" + this.driver + ", valueData=" + this.valueData + ", cmfFile=" + this.cmfFile + ")");
    }

    public static enum Distribution {
        UNIFORM,
        ZIPFIAN;

    }

    public static enum Order {
        SEQUENTIAL,
        RANDOM;

    }

    public static enum Type {
        READ,
        WRITE,
        SCAN,
        INCR;

    }
}

