/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.GenericOptionsParser;
import org.hypertable.Common.Time;
import org.hypertable.hadoop.mapreduce.Helper;
import org.hypertable.hadoop.mapreduce.KeyWritable;
import org.hypertable.hadoop.mapreduce.Mapper;
import org.hypertable.hadoop.mapreduce.Reducer;
import org.hypertable.hadoop.mapreduce.ScanSpec;

public class WikipediaBuildIndex {
    public static Arguments parseArgs(String[] args) throws ParseException {
        Arguments parsed_args = new Arguments();
        for (int i = 0; i < args.length; ++i) {
            Date ts;
            if (args[i].startsWith("--start-time=")) {
                ts = Time.parse_ts((String)args[i].substring(13));
                parsed_args.scan_spec.start_time = ts.getTime() * 1000000L;
                parsed_args.scan_spec.setStart_timeIsSet(true);
                continue;
            }
            if (!args[i].startsWith("--end-time=")) continue;
            ts = Time.parse_ts((String)args[i].substring(11));
            parsed_args.scan_spec.end_time = ts.getTime() * 1000000L;
            parsed_args.scan_spec.setEnd_timeIsSet(true);
        }
        return parsed_args;
    }

    public static void main(String[] args) throws Exception {
        Arguments parsed_args = WikipediaBuildIndex.parseArgs(args);
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = new Job(conf, "wikipedia");
        job.setJarByClass(WikipediaBuildIndex.class);
        job.setCombinerClass(IntSumReducer.class);
        parsed_args.scan_spec.addToColumns("article");
        Helper.initMapperJob((String)"/", (String)"wikipedia", (ScanSpec)parsed_args.scan_spec, TokenizerMapper.class, KeyWritable.class, IntWritable.class, (Job)job);
        Helper.initReducerJob((String)"/", (String)"wikiindex", IntSumTableReducer.class, (Job)job);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class Arguments {
        public ScanSpec scan_spec = new ScanSpec();
    }

    public static class IntSumTableReducer
    extends Reducer<KeyWritable, IntWritable> {
        public void reduce(KeyWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            byte[] vbytes = String.valueOf(sum).getBytes();
            BytesWritable output_value = new BytesWritable(vbytes);
            context.write((Object)key, (Object)output_value);
            context.progress();
        }
    }

    public static class IntSumReducer
    extends org.apache.hadoop.mapreduce.Reducer<KeyWritable, IntWritable, KeyWritable, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(KeyWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
            context.progress();
        }
    }

    public static class TokenizerMapper
    extends Mapper<KeyWritable, IntWritable> {
        private static final IntWritable one = new IntWritable(1);

        public void map(KeyWritable key, BytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
            String article = key.getRow();
            StringTokenizer st = null;
            try {
                st = new StringTokenizer(new String(value.getBytes(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                System.exit(-1);
            }
            while (st.hasMoreTokens()) {
                String rowKey = st.nextToken();
                key.setRow(rowKey);
                key.setColumn_family("article");
                key.setColumn_qualifier(article);
                context.write((Object)key, (Object)one);
            }
            context.progress();
        }
    }
}

