/*
 * Decompiled with CFR 0.152.
 */
package org.hypertable.examples;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.GenericOptionsParser;
import org.hypertable.Common.Time;
import org.hypertable.hadoop.mapreduce.Helper;
import org.hypertable.hadoop.mapreduce.KeyWritable;
import org.hypertable.hadoop.mapreduce.Mapper;
import org.hypertable.hadoop.mapreduce.Reducer;
import org.hypertable.hadoop.mapreduce.ScanSpec;
import org.hypertable.thriftgen.RowInterval;

public class WikipediaWordCount {
    public static Arguments parseArgs(String[] args) throws ParseException {
        Arguments parsed_args = new Arguments();
        RowInterval row_interval = null;
        for (int i = 0; i < args.length; ++i) {
            Date ts;
            if (args[i].startsWith("--namespace=")) {
                parsed_args.namespace = args[i].substring(12);
                continue;
            }
            if (args[i].startsWith("--row-")) {
                if (row_interval == null) {
                    row_interval = new RowInterval();
                }
                if (args[i].startsWith("--row-gt=")) {
                    row_interval.setStart_row(args[i].substring(9));
                    row_interval.setStart_inclusive(false);
                    continue;
                }
                if (args[i].startsWith("--row-ge=")) {
                    row_interval.setStart_row(args[i].substring(9));
                    row_interval.setStart_inclusive(true);
                    continue;
                }
                if (args[i].startsWith("--row-lt=")) {
                    row_interval.setEnd_row(args[i].substring(9));
                    row_interval.setEnd_inclusive(false);
                    continue;
                }
                if (args[i].startsWith("--row-le=")) {
                    row_interval.setEnd_row(args[i].substring(9));
                    row_interval.setEnd_inclusive(true);
                    continue;
                }
                System.out.println("Unsupported option: " + args[i]);
                System.exit(-1);
                continue;
            }
            if (args[i].startsWith("--start-time=")) {
                ts = Time.parse_ts((String)args[i].substring(13));
                parsed_args.scan_spec.start_time = ts.getTime() * 1000000L;
                parsed_args.scan_spec.setStart_timeIsSet(true);
                continue;
            }
            if (args[i].startsWith("--end-time=")) {
                ts = Time.parse_ts((String)args[i].substring(11));
                parsed_args.scan_spec.end_time = ts.getTime() * 1000000L;
                parsed_args.scan_spec.setEnd_timeIsSet(true);
                continue;
            }
            if (args[i].startsWith("--columns=")) {
                StringTokenizer itr = new StringTokenizer(args[i].substring(10), ",");
                ArrayList<String> columns = new ArrayList<String>();
                while (itr.hasMoreTokens()) {
                    columns.add(itr.nextToken());
                }
                parsed_args.scan_spec.setColumns(columns);
                parsed_args.scan_spec.setColumnsIsSet(true);
                continue;
            }
            System.out.println("Unsupported option: " + args[i]);
            System.exit(-1);
        }
        if (row_interval != null) {
            parsed_args.scan_spec.addToRow_intervals(row_interval);
        }
        return parsed_args;
    }

    public static void main(String[] args) throws Exception {
        Arguments parsed_args = WikipediaWordCount.parseArgs(args);
        Configuration conf = new Configuration();
        String[] otherArgs = new GenericOptionsParser(conf, args).getRemainingArgs();
        Job job = new Job(conf, "wikipedia");
        job.setJarByClass(WikipediaWordCount.class);
        job.setCombinerClass(IntSumReducer.class);
        Helper.initMapperJob((String)parsed_args.namespace, (String)"wikipedia", (ScanSpec)parsed_args.scan_spec, TokenizerMapper.class, KeyWritable.class, IntWritable.class, (Job)job);
        Helper.initReducerJob((String)parsed_args.namespace, (String)"wikipedia", IntSumTableReducer.class, (Job)job);
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class Arguments {
        public String namespace = "/";
        public ScanSpec scan_spec = new ScanSpec();
    }

    public static class IntSumTableReducer
    extends Reducer<KeyWritable, IntWritable> {
        public void reduce(KeyWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            byte[] vbytes = String.valueOf(sum).getBytes();
            BytesWritable output_value = new BytesWritable(vbytes);
            context.write((Object)key, (Object)output_value);
            context.progress();
        }
    }

    public static class IntSumReducer
    extends org.apache.hadoop.mapreduce.Reducer<KeyWritable, IntWritable, KeyWritable, IntWritable> {
        private IntWritable result = new IntWritable();

        public void reduce(KeyWritable key, Iterable<IntWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int sum = 0;
            for (IntWritable val : values) {
                sum += val.get();
            }
            this.result.set(sum);
            context.write((Object)key, (Object)this.result);
            context.progress();
        }
    }

    public static class TokenizerMapper
    extends Mapper<KeyWritable, IntWritable> {
        private static final IntWritable one = new IntWritable(1);

        public void map(KeyWritable key, BytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
            SimpleASCIITokenizer tokenizer = new SimpleASCIITokenizer();
            byte[] bytes = value.getBytes();
            tokenizer.reset(bytes);
            key.setColumn_family("word");
            while (tokenizer.next()) {
                key.setColumn_qualifier(bytes, tokenizer.getOffset(), tokenizer.getLength());
                context.write((Object)key, (Object)one);
            }
            context.progress();
        }
    }

    public static class SimpleASCIITokenizer {
        private byte[] m_buffer;
        private int m_offset;
        private int m_length;

        void reset(byte[] utf8str) {
            this.m_buffer = utf8str;
            this.m_offset = 0;
            this.m_length = 0;
        }

        boolean next() {
            this.m_offset += this.m_length;
            if (this.m_offset == this.m_buffer.length) {
                return false;
            }
            if (this.m_offset > 0) {
                ++this.m_offset;
            }
            while (!(this.m_offset >= this.m_buffer.length || this.m_buffer[this.m_offset] > 0 && Character.isLetterOrDigit((char)this.m_buffer[this.m_offset]))) {
                ++this.m_offset;
            }
            if (this.m_offset == this.m_buffer.length) {
                return false;
            }
            this.m_length = 0;
            while (this.m_offset + this.m_length < this.m_buffer.length && this.m_buffer[this.m_offset + this.m_length] > 0 && Character.isLetterOrDigit((char)this.m_buffer[this.m_offset + this.m_length])) {
                ++this.m_length;
            }
            return true;
        }

        int getOffset() {
            return this.m_offset;
        }

        int getLength() {
            return this.m_length;
        }
    }
}

