/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.filecache;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.filecache.TaskDistributedCacheManager;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.MRAsyncDiskService;
import org.apache.hadoop.util.RunJar;

public class TrackerDistributedCacheManager {
    private TreeMap<String, CacheStatus> cachedArchives = new TreeMap();
    private Map<JobID, TaskDistributedCacheManager> jobArchives = Collections.synchronizedMap(new HashMap());
    private final TaskController taskController;
    private static final FsPermission PUBLIC_CACHE_OBJECT_PERM = FsPermission.createImmutable((short)493);
    private TreeMap<Path, CacheDir> baseDirProperties = new TreeMap();
    private static final long DEFAULT_CACHE_SIZE = 0x280000000L;
    private static final long DEFAULT_CACHE_SUBDIR_LIMIT = 10000L;
    private long allowedCacheSize;
    private long allowedCacheSubdirs;
    private static final Log LOG = LogFactory.getLog(TrackerDistributedCacheManager.class);
    private final LocalFileSystem localFs;
    private LocalDirAllocator lDirAllocator;
    private Configuration trackerConf;
    private static final Random random = new Random();
    private MRAsyncDiskService asyncDiskService;

    public TrackerDistributedCacheManager(Configuration conf, TaskController controller) throws IOException {
        this.localFs = FileSystem.getLocal(conf);
        this.trackerConf = conf;
        this.lDirAllocator = new LocalDirAllocator("mapred.local.dir");
        this.allowedCacheSize = conf.getLong("local.cache.size", 0x280000000L);
        this.allowedCacheSubdirs = conf.getLong("mapreduce.tasktracker.cache.local.numberdirectories", 10000L);
        this.taskController = controller;
    }

    public TrackerDistributedCacheManager(Configuration conf, TaskController taskController, MRAsyncDiskService asyncDiskService) throws IOException {
        this(conf, taskController);
        this.asyncDiskService = asyncDiskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Path getLocalCache(URI cache, Configuration conf, String subDir, FileStatus fileStatus, boolean isArchive, long confFileStamp, boolean isPublic, TaskDistributedCacheManager.CacheFile file) throws IOException {
        CacheStatus cacheStatus;
        CacheStatus lcacheStatus;
        String user = TrackerDistributedCacheManager.getLocalizedCacheOwner(isPublic);
        String key = this.getKey(cache, conf, confFileStamp, user);
        Path localizedPath = null;
        Path localPath = null;
        Object object = this.cachedArchives;
        synchronized (object) {
            lcacheStatus = this.cachedArchives.get(key);
            if (lcacheStatus == null) {
                String uniqueString = String.valueOf(random.nextLong()) + "_" + cache.hashCode() + "_" + confFileStamp % Integer.MAX_VALUE;
                String cachePath = new Path(subDir, new Path(uniqueString, this.makeRelative(cache, conf))).toString();
                localPath = this.lDirAllocator.getLocalPathForWrite(cachePath, fileStatus.getLen(), this.trackerConf, isPublic);
                lcacheStatus = new CacheStatus(new Path(localPath.toString().replace(cachePath, "")), localPath, new Path(subDir), uniqueString, isPublic ? null : user);
                this.cachedArchives.put(key, lcacheStatus);
            }
            file.setStatus(lcacheStatus);
            cacheStatus = lcacheStatus;
            synchronized (cacheStatus) {
                ++lcacheStatus.refcount;
            }
        }
        try {
            object = lcacheStatus;
            synchronized (object) {
                if (!lcacheStatus.isInited()) {
                    if (isPublic) {
                        localizedPath = this.localizePublicCacheObject(conf, cache, confFileStamp, lcacheStatus, fileStatus, isArchive);
                    } else {
                        localizedPath = localPath;
                        if (!isArchive) {
                            lcacheStatus.size = fileStatus.getLen();
                            this.addCacheInfoUpdate(lcacheStatus);
                        }
                    }
                    lcacheStatus.initComplete();
                } else {
                    localizedPath = this.checkCacheStatusValidity(conf, cache, confFileStamp, lcacheStatus, fileStatus, isArchive);
                }
            }
            long size = 0L;
            long numberSubdirs = 0L;
            CacheStatus cacheStatus2 = lcacheStatus;
            synchronized (cacheStatus2) {
                TreeMap<Path, CacheDir> treeMap = this.baseDirProperties;
                synchronized (treeMap) {
                    CacheDir cacheDir = this.baseDirProperties.get(lcacheStatus.getBaseDir());
                    if (cacheDir != null) {
                        size = cacheDir.size;
                        numberSubdirs = cacheDir.subdirs;
                    } else {
                        LOG.warn((Object)("Cannot find size and number of subdirectories of baseDir: " + lcacheStatus.getBaseDir()));
                    }
                }
            }
            if (this.allowedCacheSize < size || this.allowedCacheSubdirs < numberSubdirs) {
                this.compactCache(conf);
            }
        }
        catch (IOException ie) {
            cacheStatus = lcacheStatus;
            synchronized (cacheStatus) {
                --lcacheStatus.refcount;
                throw ie;
            }
        }
        return localizedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseCache(CacheStatus status) throws IOException {
        CacheStatus cacheStatus = status;
        synchronized (cacheStatus) {
            --status.refcount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSize(CacheStatus status, long size) throws IOException {
        if (size != 0L) {
            CacheStatus cacheStatus = status;
            synchronized (cacheStatus) {
                status.size = size;
                this.addCacheInfoUpdate(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getReferenceCount(CacheStatus status) throws IOException {
        CacheStatus cacheStatus = status;
        synchronized (cacheStatus) {
            return status.refcount;
        }
    }

    static String getLocalizedCacheOwner(boolean isPublic) throws IOException {
        String user = isPublic ? UserGroupInformation.getLoginUser().getShortUserName() : UserGroupInformation.getCurrentUser().getShortUserName();
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactCache(Configuration conf) throws IOException {
        LinkedList<CacheStatus> deleteList = new LinkedList<CacheStatus>();
        TreeMap<String, CacheStatus> treeMap = this.cachedArchives;
        synchronized (treeMap) {
            Iterator<String> it = this.cachedArchives.keySet().iterator();
            while (it.hasNext()) {
                String cacheId = it.next();
                CacheStatus lcacheStatus = this.cachedArchives.get(cacheId);
                if (lcacheStatus.refcount != 0) continue;
                deleteList.add(lcacheStatus);
                it.remove();
            }
        }
        Iterator i$ = deleteList.iterator();
        while (i$.hasNext()) {
            CacheStatus lcacheStatus;
            CacheStatus cacheStatus = lcacheStatus = (CacheStatus)i$.next();
            synchronized (cacheStatus) {
                Path localizedDir = lcacheStatus.getLocalizedUniqueDir();
                if (lcacheStatus.user == null) {
                    LOG.info((Object)("Deleted path " + localizedDir));
                    try {
                        TrackerDistributedCacheManager.deleteLocalPath(this.asyncDiskService, this.localFs, lcacheStatus.getLocalizedUniqueDir());
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Could not delete distributed cache empty directory " + lcacheStatus.getLocalizedUniqueDir()));
                    }
                } else {
                    LOG.info((Object)("Deleted path " + localizedDir + " as " + lcacheStatus.user));
                    String base = lcacheStatus.getBaseDir().toString();
                    String userDir = TaskTracker.getUserDir(lcacheStatus.user);
                    int skip = base.length() + 1 + userDir.length() + 1;
                    String relative = localizedDir.toString().substring(skip);
                    this.taskController.deleteAsUser(lcacheStatus.user, relative);
                }
                this.deleteCacheInfoUpdate(lcacheStatus);
            }
        }
    }

    private static void deleteLocalPath(MRAsyncDiskService asyncDiskService, LocalFileSystem fs, Path path) throws IOException {
        String localPathToDelete;
        boolean deleted = false;
        if (asyncDiskService != null && !(deleted = asyncDiskService.moveAndDeleteAbsolutePath(localPathToDelete = path.toUri().getPath()))) {
            LOG.warn((Object)("Cannot find DistributedCache path " + localPathToDelete + " on any of the asyncDiskService volumes!"));
        }
        if (!deleted) {
            fs.delete(path, true);
        }
        LOG.info((Object)("Deleted path " + path));
    }

    String makeRelative(URI cache, Configuration conf) throws IOException {
        URI defaultUri;
        String host = cache.getHost();
        if (host == null) {
            host = cache.getScheme();
        }
        if (host == null && (host = (defaultUri = FileSystem.get(conf).getUri()).getHost()) == null) {
            host = defaultUri.getScheme();
        }
        String path = host + cache.getPath();
        path = path.replace(":/", "/");
        return path;
    }

    private Path checkCacheStatusValidity(Configuration conf, URI cache, long confFileStamp, CacheStatus cacheStatus, FileStatus fileStatus, boolean isArchive) throws IOException {
        FileSystem fs = FileSystem.get(cache, conf);
        if (!this.ifExistsAndFresh(conf, fs, cache, confFileStamp, cacheStatus, fileStatus)) {
            throw new IOException("Stale cache file: " + cacheStatus.localizedLoadPath + " for cache-file: " + cache);
        }
        LOG.info((Object)String.format("Using existing cache of %s->%s", cache.toString(), cacheStatus.localizedLoadPath));
        return cacheStatus.localizedLoadPath;
    }

    static boolean isPublic(Configuration conf, URI uri) throws IOException {
        Path current;
        FileSystem fs = FileSystem.get(uri, conf);
        if (!TrackerDistributedCacheManager.checkPermissionOfOther(fs, current = new Path(uri.getPath()), FsAction.READ)) {
            return false;
        }
        return TrackerDistributedCacheManager.ancestorsHaveExecutePermissions(fs, current.getParent());
    }

    static boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path) throws IOException {
        for (Path current = path; current != null; current = current.getParent()) {
            if (TrackerDistributedCacheManager.checkPermissionOfOther(fs, current, FsAction.EXECUTE)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action) throws IOException {
        FileStatus status = fs.getFileStatus(path);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    private static Path createRandomPath(Path base) throws IOException {
        return new Path(base.toString() + "-work-" + random.nextLong());
    }

    public static long downloadCacheObject(Configuration conf, URI source, Path destination, long desiredTimestamp, boolean isArchive, FsPermission permission) throws IOException {
        FileSystem sourceFs = FileSystem.get(source, conf);
        LocalFileSystem localFs = FileSystem.getLocal(conf);
        Path sourcePath = new Path(source.getPath());
        long modifiedTime = sourceFs.getFileStatus(sourcePath).getModificationTime();
        if (modifiedTime != desiredTimestamp) {
            DateFormat df = DateFormat.getDateTimeInstance(3, 3);
            throw new IOException("The distributed cache object " + source + " changed during the job from " + df.format(new Date(desiredTimestamp)) + " to " + df.format(new Date(modifiedTime)));
        }
        Path parchive = null;
        parchive = isArchive ? new Path(destination, destination.getName()) : destination;
        if (localFs.exists(parchive)) {
            return 0L;
        }
        Path finalDir = parchive.getParent();
        Path workDir = TrackerDistributedCacheManager.createRandomPath(finalDir);
        LOG.info((Object)("Creating " + destination.getName() + " in " + workDir + " with " + permission));
        if (!((FileSystem)localFs).mkdirs(workDir, permission)) {
            throw new IOException("Mkdirs failed to create directory " + workDir);
        }
        Path workFile = new Path(workDir, parchive.getName());
        sourceFs.copyToLocalFile(sourcePath, workFile);
        ((FileSystem)localFs).setPermission(workFile, permission);
        if (isArchive) {
            String tmpArchive = workFile.getName().toLowerCase();
            File srcFile = new File(workFile.toString());
            File destDir = new File(workDir.toString());
            LOG.info((Object)String.format("Extracting %s to %s", srcFile.toString(), destDir.toString()));
            if (tmpArchive.endsWith(".jar")) {
                RunJar.unJar(srcFile, destDir);
            } else if (tmpArchive.endsWith(".zip")) {
                FileUtil.unZip(srcFile, destDir);
            } else if (TrackerDistributedCacheManager.isTarFile(tmpArchive)) {
                FileUtil.unTar(srcFile, destDir);
            } else {
                LOG.warn((Object)String.format("Cache file %s specified as archive, but not valid extension.", srcFile.toString()));
            }
            try {
                FileUtil.chmod(destDir.toString(), "ugo+rx", true);
            }
            catch (InterruptedException ie) {
                throw new IOException("Interrupted while chmodding", ie);
            }
        }
        if (!((FileSystem)localFs).rename(workDir, finalDir)) {
            ((FileSystem)localFs).delete(workDir, true);
            if (!localFs.exists(finalDir)) {
                throw new IOException("Failed to promote distributed cache object " + workDir + " to " + finalDir);
            }
            return 0L;
        }
        LOG.info((Object)String.format("Cached %s as %s", source.toString(), destination.toString()));
        long cacheSize = FileUtil.getDU(new File(parchive.getParent().toString()));
        return cacheSize;
    }

    Path localizePublicCacheObject(Configuration conf, URI cache, long confFileStamp, CacheStatus cacheStatus, FileStatus fileStatus, boolean isArchive) throws IOException {
        long size;
        cacheStatus.size = size = TrackerDistributedCacheManager.downloadCacheObject(conf, cache, cacheStatus.localizedLoadPath, confFileStamp, isArchive, PUBLIC_CACHE_OBJECT_PERM);
        this.addCacheInfoUpdate(cacheStatus);
        LOG.info((Object)String.format("Cached %s as %s", cache.toString(), cacheStatus.localizedLoadPath));
        return cacheStatus.localizedLoadPath;
    }

    private static boolean isTarFile(String filename) {
        return filename.endsWith(".tgz") || filename.endsWith(".tar.gz") || filename.endsWith(".tar");
    }

    private boolean ifExistsAndFresh(Configuration conf, FileSystem fs, URI cache, long confFileStamp, CacheStatus lcacheStatus, FileStatus fileStatus) throws IOException {
        long dfsFileStamp = fileStatus != null ? fileStatus.getModificationTime() : DistributedCache.getTimestamp(conf, cache);
        if (dfsFileStamp != confFileStamp) {
            LOG.fatal((Object)("File: " + cache + " has changed on HDFS since job started"));
            throw new IOException("File: " + cache + " has changed on HDFS since job started");
        }
        return true;
    }

    String getKey(URI cache, Configuration conf, long timeStamp, String user) throws IOException {
        return this.makeRelative(cache, conf) + String.valueOf(timeStamp) + user;
    }

    public static void createAllSymlink(Configuration conf, File jobCacheDir, File workDir) throws IOException {
        if (jobCacheDir == null || !jobCacheDir.isDirectory() || workDir == null || !workDir.isDirectory()) {
            return;
        }
        boolean createSymlink = DistributedCache.getSymlink(conf);
        if (createSymlink) {
            File[] list = jobCacheDir.listFiles();
            for (int i = 0; i < list.length; ++i) {
                String target = list[i].getAbsolutePath();
                String link = new File(workDir, list[i].getName()).toString();
                LOG.info((Object)String.format("Creating symlink: %s <- %s", target, link));
                int ret = FileUtil.symLink(target, link);
                if (ret == 0) continue;
                LOG.warn((Object)String.format("Failed to create symlink: %s <- %s", target, link));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeCache() {
        TreeMap<String, CacheStatus> treeMap = this.cachedArchives;
        synchronized (treeMap) {
            for (Map.Entry<String, CacheStatus> f : this.cachedArchives.entrySet()) {
                try {
                    TrackerDistributedCacheManager.deleteLocalPath(this.asyncDiskService, this.localFs, f.getValue().localizedLoadPath);
                }
                catch (IOException ie) {
                    LOG.debug((Object)"Error cleaning up cache", (Throwable)ie);
                }
            }
            this.cachedArchives.clear();
        }
    }

    public TaskDistributedCacheManager newTaskDistributedCacheManager(JobID jobId, Configuration taskConf) throws IOException {
        TaskDistributedCacheManager result = new TaskDistributedCacheManager(this, taskConf);
        this.jobArchives.put(jobId, result);
        return result;
    }

    public void setArchiveSizes(JobID jobId, long[] sizes) throws IOException {
        TaskDistributedCacheManager mgr = this.jobArchives.get(jobId);
        if (mgr != null) {
            mgr.setSizes(sizes);
        }
    }

    public void removeTaskDistributedCacheManager(JobID jobId) {
        this.jobArchives.remove(jobId);
    }

    protected TaskDistributedCacheManager getTaskDistributedCacheManager(JobID jobId) {
        return this.jobArchives.get(jobId);
    }

    public static void determineTimestamps(Configuration job) throws IOException {
        URI[] tfiles;
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        if (tarchives != null) {
            FileStatus status = DistributedCache.getFileStatus(job, tarchives[0]);
            StringBuffer archiveFileSizes = new StringBuffer(String.valueOf(status.getLen()));
            StringBuffer archiveTimestamps = new StringBuffer(String.valueOf(status.getModificationTime()));
            for (int i = 1; i < tarchives.length; ++i) {
                status = DistributedCache.getFileStatus(job, tarchives[i]);
                archiveFileSizes.append(",");
                archiveFileSizes.append(String.valueOf(status.getLen()));
                archiveTimestamps.append(",");
                archiveTimestamps.append(String.valueOf(status.getModificationTime()));
            }
            job.set("mapred.cache.archives.filesizes", archiveFileSizes.toString());
            DistributedCache.setArchiveTimestamps(job, archiveTimestamps.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            FileStatus status = DistributedCache.getFileStatus(job, tfiles[0]);
            StringBuffer fileSizes = new StringBuffer(String.valueOf(status.getLen()));
            StringBuffer fileTimestamps = new StringBuffer(String.valueOf(status.getModificationTime()));
            for (int i = 1; i < tfiles.length; ++i) {
                status = DistributedCache.getFileStatus(job, tfiles[i]);
                fileSizes.append(",");
                fileSizes.append(String.valueOf(status.getLen()));
                fileTimestamps.append(",");
                fileTimestamps.append(String.valueOf(status.getModificationTime()));
            }
            job.set("mapred.cache.files.filesizes", fileSizes.toString());
            DistributedCache.setFileTimestamps(job, fileTimestamps.toString());
        }
    }

    public static void determineCacheVisibilities(Configuration job) throws IOException {
        URI[] tfiles;
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        if (tarchives != null) {
            StringBuffer archiveVisibilities = new StringBuffer(String.valueOf(TrackerDistributedCacheManager.isPublic(job, tarchives[0])));
            for (int i = 1; i < tarchives.length; ++i) {
                archiveVisibilities.append(",");
                archiveVisibilities.append(String.valueOf(TrackerDistributedCacheManager.isPublic(job, tarchives[i])));
            }
            TrackerDistributedCacheManager.setArchiveVisibilities(job, archiveVisibilities.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            StringBuffer fileVisibilities = new StringBuffer(String.valueOf(TrackerDistributedCacheManager.isPublic(job, tfiles[0])));
            for (int i = 1; i < tfiles.length; ++i) {
                fileVisibilities.append(",");
                fileVisibilities.append(String.valueOf(TrackerDistributedCacheManager.isPublic(job, tfiles[i])));
            }
            TrackerDistributedCacheManager.setFileVisibilities(job, fileVisibilities.toString());
        }
    }

    private static boolean[] parseBooleans(String[] strs) {
        if (null == strs) {
            return null;
        }
        boolean[] result = new boolean[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            result[i] = Boolean.parseBoolean(strs[i]);
        }
        return result;
    }

    public static boolean[] getFileVisibilities(Configuration conf) {
        return TrackerDistributedCacheManager.parseBooleans(conf.getStrings("mapreduce.job.cache.files.visibilities"));
    }

    public static boolean[] getArchiveVisibilities(Configuration conf) {
        return TrackerDistributedCacheManager.parseBooleans(conf.getStrings("mapreduce.job.cache.archives.visibilities"));
    }

    static void setArchiveVisibilities(Configuration conf, String booleans) {
        conf.set("mapreduce.job.cache.archives.visibilities", booleans);
    }

    static void setFileVisibilities(Configuration conf, String booleans) {
        conf.set("mapreduce.job.cache.files.visibilities", booleans);
    }

    public static void getDelegationTokens(Configuration job, Credentials credentials) throws IOException {
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        URI[] tfiles = DistributedCache.getCacheFiles(job);
        int size = (tarchives != null ? tarchives.length : 0) + (tfiles != null ? tfiles.length : 0);
        Path[] ps = new Path[size];
        int i = 0;
        if (tarchives != null) {
            for (i = 0; i < tarchives.length; ++i) {
                ps[i] = new Path(tarchives[i].toString());
            }
        }
        if (tfiles != null) {
            for (int j = 0; j < tfiles.length; ++j) {
                ps[i + j] = new Path(tfiles[j].toString());
            }
        }
        TokenCache.obtainTokensForNamenodes(credentials, ps, job);
    }

    public static void validate(Configuration conf) throws InvalidJobConfException {
        String[] archiveStrings = conf.getStrings("mapred.cache.archives");
        String[] fileStrings = conf.getStrings("mapred.cache.files");
        Path thisSubject = null;
        if (archiveStrings != null && fileStrings != null) {
            HashSet<Path> archivesSet = new HashSet<Path>();
            for (String archiveString : archiveStrings) {
                archivesSet.add(TrackerDistributedCacheManager.coreLocation(archiveString, conf));
            }
            for (String fileString : fileStrings) {
                thisSubject = TrackerDistributedCacheManager.coreLocation(fileString, conf);
                if (!archivesSet.contains(thisSubject)) continue;
                throw new InvalidJobConfException("The core URI, \"" + thisSubject + "\" is listed both in " + "mapred.cache.files" + " and in " + "mapred.cache.archives" + " .");
            }
        }
    }

    private static Path coreLocation(String uriString, Configuration conf) throws InvalidJobConfException {
        if (DistributedCache.getSymlink(conf)) {
            try {
                URI uri = new URI(uriString);
                uriString = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new InvalidJobConfException("Badly formatted URI: " + uriString, e);
            }
        }
        Path path = new Path(uriString);
        try {
            path = path.makeQualified(path.getFileSystem(conf));
        }
        catch (IOException e) {
            throw new InvalidJobConfException("Invalid file system in distributed cache for the URI: " + uriString, e);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCacheInfoUpdate(CacheStatus cacheStatus) {
        if (!cacheStatus.inited) {
            return;
        }
        TreeMap<Path, CacheDir> treeMap = this.baseDirProperties;
        synchronized (treeMap) {
            CacheDir cacheDir = this.baseDirProperties.get(cacheStatus.getBaseDir());
            if (cacheDir != null) {
                cacheDir.size -= cacheStatus.size;
                --cacheDir.subdirs;
            } else {
                LOG.warn((Object)("Cannot find size and number of subdirectories of baseDir: " + cacheStatus.getBaseDir()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCacheInfoUpdate(CacheStatus cacheStatus) {
        long cacheSize = cacheStatus.size;
        TreeMap<Path, CacheDir> treeMap = this.baseDirProperties;
        synchronized (treeMap) {
            CacheDir cacheDir = this.baseDirProperties.get(cacheStatus.getBaseDir());
            if (cacheDir != null) {
                cacheDir.size += cacheSize;
                ++cacheDir.subdirs;
            } else {
                cacheDir = new CacheDir();
                cacheDir.size = cacheSize;
                cacheDir.subdirs = 1L;
                this.baseDirProperties.put(cacheStatus.getBaseDir(), cacheDir);
            }
        }
    }

    static class CacheStatus {
        Path localizedLoadPath;
        Path localizedBaseDir;
        long size;
        int refcount;
        boolean inited = false;
        Path subDir;
        String uniqueString;
        final String user;

        public CacheStatus(Path baseDir, Path localLoadPath, Path subDir, String uniqueString, String user) {
            this.localizedLoadPath = localLoadPath;
            this.refcount = 0;
            this.localizedBaseDir = baseDir;
            this.size = 0L;
            this.subDir = subDir;
            this.uniqueString = uniqueString;
            this.user = user;
        }

        Path getBaseDir() {
            return this.localizedBaseDir;
        }

        void initComplete() {
            this.inited = true;
        }

        boolean isInited() {
            return this.inited;
        }

        Path getLocalizedUniqueDir() {
            return new Path(this.localizedBaseDir, new Path(this.subDir, this.uniqueString));
        }
    }

    static class CacheDir {
        long size;
        long subdirs;

        CacheDir() {
        }
    }
}

