/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.SkipPageException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.VersionInfo;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspSourceDependent;

public final class dfshealth_jsp
extends HttpJspBase
implements JspSourceDependent,
SingleThreadModel {
    JspHelper jspHelper = new JspHelper();
    int rowNum = 0;
    int colNum = 0;
    long diskBytes = 0x40000000L;
    String diskByteStr = "GB";
    String sorterField = null;
    String sorterOrder = null;
    private static List _jspx_dependants;

    String rowTxt() {
        this.colNum = 0;
        return "<tr class=\"" + (this.rowNum++ % 2 == 0 ? "rowNormal" : "rowAlt") + "\"> ";
    }

    String colTxt() {
        return "<td id=\"col" + ++this.colNum + "\"> ";
    }

    void counterReset() {
        this.colNum = 0;
        this.rowNum = 0;
    }

    String NodeHeaderStr(String name) {
        String ret = "class=header";
        String order = "ASC";
        if (name.equals(this.sorterField)) {
            ret = ret + this.sorterOrder;
            if (this.sorterOrder.equals("ASC")) {
                order = "DSC";
            }
        }
        ret = ret + " onClick=\"window.document.location='/dfshealth.jsp?sorter/field=" + name + "&sorter/order=" + order + "'\" title=\"sort on this column\"";
        return ret;
    }

    public void generateNodeData(JspWriter out, DatanodeDescriptor d, String suffix, boolean alive, int nnHttpPort) throws IOException {
        String url = "http://" + d.getHostName() + ":" + d.getInfoPort() + "/browseDirectory.jsp?namenodeInfoPort=" + nnHttpPort + "&dir=" + URLEncoder.encode("/", "UTF-8");
        String name = d.getHostName() + ":" + d.getPort();
        if (!name.matches("\\d+\\.\\d+.\\d+\\.\\d+.*")) {
            name = name.replaceAll("\\.[^.:]*", "");
        }
        int idx = suffix != null && name.endsWith(suffix) ? name.indexOf(suffix) : -1;
        out.print(this.rowTxt() + "<td class=\"name\"><a title=\"" + d.getHost() + ":" + d.getPort() + "\" href=\"" + url + "\">" + (idx > 0 ? name.substring(0, idx) : name) + "</a>" + (alive ? "" : "\n"));
        if (!alive) {
            return;
        }
        long c = d.getCapacity();
        long u = d.getDfsUsed();
        long nu = d.getNonDfsUsed();
        long r = d.getRemaining();
        String percentUsed = StringUtils.limitDecimalTo2(d.getDfsUsedPercent());
        String percentRemaining = StringUtils.limitDecimalTo2(d.getRemainingPercent());
        String adminState = d.isDecommissioned() ? "Decommissioned" : (d.isDecommissionInProgress() ? "Decommission In Progress" : "In Service");
        long timestamp = d.getLastUpdate();
        long currentTime = System.currentTimeMillis();
        out.print("<td class=\"lastcontact\"> " + (currentTime - timestamp) / 1000L + "<td class=\"adminstate\">" + adminState + "<td align=\"right\" class=\"capacity\">" + StringUtils.limitDecimalTo2((double)c * 1.0 / (double)this.diskBytes) + "<td align=\"right\" class=\"used\">" + StringUtils.limitDecimalTo2((double)u * 1.0 / (double)this.diskBytes) + "<td align=\"right\" class=\"nondfsused\">" + StringUtils.limitDecimalTo2((double)nu * 1.0 / (double)this.diskBytes) + "<td align=\"right\" class=\"remaining\">" + StringUtils.limitDecimalTo2((double)r * 1.0 / (double)this.diskBytes) + "<td align=\"right\" class=\"pcused\">" + percentUsed + "<td class=\"pcused\">" + ServletUtil.percentageGraph((int)Double.parseDouble(percentUsed), 100) + "<td align=\"right\" class=\"pcremaining`\">" + percentRemaining + "<td title=" + "\"blocks scheduled : " + d.getBlocksScheduled() + "\" class=\"blocks\">" + d.numBlocks() + "\n");
    }

    public void generateConfReport(JspWriter out, FSNamesystem fsn, HttpServletRequest request) throws IOException {
        long underReplicatedBlocks = fsn.getUnderReplicatedBlocks();
        FSImage fsImage = fsn.getFSImage();
        List<Storage.StorageDirectory> removedStorageDirs = fsImage.getRemovedStorageDirs();
        String storageDirsSizeStr = "";
        String removedStorageDirsSizeStr = "";
        String storageDirsStr = "";
        String removedStorageDirsStr = "";
        String storageDirsDiv = "";
        String removedStorageDirsDiv = "";
        out.print("<h3> NameNode Storage: </h3>");
        out.print("<div id=\"dfstable\"> <table border=1 cellpadding=10 cellspacing=0 title=\"NameNode Storage\">\n<thead><tr><td><b>Storage Directory</b></td><td><b>Type</b></td><td><b>State</b></td></tr></thead>");
        Storage.StorageDirectory st = null;
        Iterator<Storage.StorageDirectory> it = fsImage.dirIterator();
        while (it.hasNext()) {
            st = it.next();
            String dir = "" + st.getRoot();
            String type = "" + st.getStorageDirType();
            out.print("<tr><td>" + dir + "</td><td>" + type + "</td><td>Active</td></tr>");
        }
        long storageDirsSize = removedStorageDirs.size();
        int i = 0;
        while ((long)i < storageDirsSize) {
            st = removedStorageDirs.get(i);
            String dir = "" + st.getRoot();
            String type = "" + st.getStorageDirType();
            out.print("<tr><td>" + dir + "</td><td>" + type + "</td><td><font color=red>Failed</font></td></tr>");
            ++i;
        }
        out.print("</table></div><br>\n");
    }

    public void generateDFSHealthReport(JspWriter out, NameNode nn, HttpServletRequest request) throws IOException {
        FSNamesystem fsn = nn.getNamesystem();
        ArrayList<DatanodeDescriptor> live = new ArrayList<DatanodeDescriptor>();
        ArrayList<DatanodeDescriptor> dead = new ArrayList<DatanodeDescriptor>();
        this.jspHelper.DFSNodesStatus(live, dead);
        ArrayList<DatanodeDescriptor> decommissioning = fsn.getDecommissioningNodes();
        this.sorterField = request.getParameter("sorter/field");
        this.sorterOrder = request.getParameter("sorter/order");
        if (this.sorterField == null) {
            this.sorterField = "name";
        }
        if (this.sorterOrder == null) {
            this.sorterOrder = "ASC";
        }
        String port_suffix = null;
        if (live.size() > 0) {
            String name = live.get(0).getName();
            int idx = name.indexOf(58);
            if (idx > 0) {
                port_suffix = name.substring(idx);
            }
            for (int i = 1; port_suffix != null && i < live.size(); ++i) {
                if (live.get(i).getName().endsWith(port_suffix)) continue;
                port_suffix = null;
                break;
            }
        }
        this.counterReset();
        long[] fsnStats = fsn.getStats();
        long total = fsnStats[0];
        long remaining = fsnStats[2];
        long used = fsnStats[1];
        long nonDFS = total - remaining - used;
        nonDFS = nonDFS < 0L ? 0L : nonDFS;
        float percentUsed = total <= 0L ? 0.0f : (float)used * 100.0f / (float)total;
        float percentRemaining = total <= 0L ? 100.0f : (float)remaining * 100.0f / (float)total;
        out.print("<div id=\"dfstable\"> <table>\n" + this.rowTxt() + this.colTxt() + "Configured Capacity" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(total) + this.rowTxt() + this.colTxt() + "DFS Used" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(used) + this.rowTxt() + this.colTxt() + "Non DFS Used" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(nonDFS) + this.rowTxt() + this.colTxt() + "DFS Remaining" + this.colTxt() + ":" + this.colTxt() + StringUtils.byteDesc(remaining) + this.rowTxt() + this.colTxt() + "DFS Used%" + this.colTxt() + ":" + this.colTxt() + StringUtils.limitDecimalTo2(percentUsed) + " %" + this.rowTxt() + this.colTxt() + "DFS Remaining%" + this.colTxt() + ":" + this.colTxt() + StringUtils.limitDecimalTo2(percentRemaining) + " %" + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=LIVE\">Live Nodes</a> " + this.colTxt() + ":" + this.colTxt() + live.size() + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=DEAD\">Dead Nodes</a> " + this.colTxt() + ":" + this.colTxt() + dead.size() + this.rowTxt() + this.colTxt() + "<a href=\"dfsnodelist.jsp?whatNodes=DECOMMISSIONING\">" + "Decommissioning Nodes</a> " + this.colTxt() + ":" + this.colTxt() + decommissioning.size() + this.rowTxt() + this.colTxt() + "Number of Under-Replicated Blocks" + this.colTxt() + ":" + this.colTxt() + fsn.getUnderReplicatedBlocks() + "</table></div><br>\n");
        if (live.isEmpty() && dead.isEmpty()) {
            out.print("There are no datanodes in the cluster");
        }
    }

    public Object getDependants() {
        return _jspx_dependants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _jspService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JspFactory _jspxFactory = null;
        PageContext pageContext = null;
        HttpSession session = null;
        ServletContext application = null;
        ServletConfig config = null;
        JspWriter out = null;
        dfshealth_jsp page = this;
        JspWriter _jspx_out = null;
        PageContext _jspx_page_context = null;
        try {
            _jspxFactory = JspFactory.getDefaultFactory();
            response.setContentType("text/html; charset=UTF-8");
            _jspx_page_context = pageContext = _jspxFactory.getPageContext((Servlet)this, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            application = pageContext.getServletContext();
            config = pageContext.getServletConfig();
            session = pageContext.getSession();
            _jspx_out = out = pageContext.getOut();
            out.write(10);
            out.write(10);
            out.write(10);
            NameNode nn = (NameNode)application.getAttribute("name.node");
            FSNamesystem fsn = nn.getNamesystem();
            String namenodeLabel = nn.getNameNodeAddress().getHostName() + ":" + nn.getNameNodeAddress().getPort();
            out.write("\n\n<html>\n\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hadoop.css\">\n<link rel=\"icon\" type=\"image/vnd.microsoft.icon\" href=\"/static/images/favicon.ico\" />\n<title>Hadoop NameNode ");
            out.print(namenodeLabel);
            out.write("</title>\n    \n<body>\n<h1>NameNode '");
            out.print(namenodeLabel);
            out.write("'</h1>\n\n\n<div id=\"dfstable\"> <table>\t  \n<tr> <td id=\"col1\"> Started: <td> ");
            out.print((Object)fsn.getStartTime());
            out.write("\n<tr> <td id=\"col1\"> Version: <td> ");
            out.print(VersionInfo.getVersion());
            out.write(44);
            out.write(32);
            out.print(VersionInfo.getRevision());
            out.write("\n<tr> <td id=\"col1\"> Compiled: <td> ");
            out.print(VersionInfo.getDate());
            out.write(" by ");
            out.print(VersionInfo.getUser());
            out.write(" from ");
            out.print(VersionInfo.getBranch());
            out.write("\n<tr> <td id=\"col1\"> Upgrades: <td> ");
            out.print(this.jspHelper.getUpgradeStatusText());
            out.write("\n</table></div><br>\t\t\t\t      \n\n<b><a href=\"/nn_browsedfscontent.jsp\">Browse the filesystem</a></b><br>\n<b><a href=\"/logs/\">Namenode Logs</a></b>\n\n<hr>\n<h3>Cluster Summary</h3>\n<b> ");
            out.print(this.jspHelper.getSafeModeText());
            out.write(" </b>\n<b> ");
            out.print(this.jspHelper.getInodeLimitText());
            out.write(" </b>\n<a class=\"warning\"> ");
            out.print(JspHelper.getWarningText(fsn));
            out.write("</a>\n\n");
            this.generateDFSHealthReport(out, nn, request);
            out.write("\n<hr>\n");
            this.generateConfReport(out, fsn, request);
            out.write(10);
            out.println(ServletUtil.htmlFooter());
            out.write(10);
            if (_jspxFactory == null) return;
        }
        catch (Throwable t) {
            try {
                if (t instanceof SkipPageException) return;
                out = _jspx_out;
                if (out != null && out.getBufferSize() != 0) {
                    out.clearBuffer();
                }
                if (_jspx_page_context == null) return;
                _jspx_page_context.handlePageException(t);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (_jspxFactory != null) {
                    _jspxFactory.releasePageContext(_jspx_page_context);
                }
            }
        }
        _jspxFactory.releasePageContext(_jspx_page_context);
        return;
    }
}

