/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ipc.ConnectionHeader;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.Status;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SaslRpcClient;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenInfo;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.util.ReflectionUtils;

public class Client {
    public static final Log LOG = LogFactory.getLog(Client.class);
    private Hashtable<ConnectionId, Connection> connections = new Hashtable();
    private Class<? extends Writable> valueClass;
    private int counter;
    private AtomicBoolean running = new AtomicBoolean(true);
    private final Configuration conf;
    private SocketFactory socketFactory;
    private int refCount = 1;
    private static final String PING_INTERVAL_NAME = "ipc.ping.interval";
    static final int DEFAULT_PING_INTERVAL = 60000;
    static final int PING_CALL_ID = -1;
    private static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactory(){
        private final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        private final AtomicInteger counter = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultThreadFactory.newThread(r);
            thread.setDaemon(true);
            thread.setName("sendParams-" + this.counter.getAndIncrement());
            return thread;
        }
    };
    private static final ExecutorService SEND_PARAMS_EXECUTOR = Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY);

    public static final void setPingInterval(Configuration conf, int pingInterval) {
        conf.setInt(PING_INTERVAL_NAME, pingInterval);
    }

    static final int getPingInterval(Configuration conf) {
        return conf.getInt(PING_INTERVAL_NAME, 60000);
    }

    synchronized void incCount() {
        ++this.refCount;
    }

    synchronized void decCount() {
        --this.refCount;
    }

    synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    public Client(Class<? extends Writable> valueClass, Configuration conf, SocketFactory factory) {
        this.valueClass = valueClass;
        this.conf = conf;
        this.socketFactory = factory;
    }

    public Client(Class<? extends Writable> valueClass, Configuration conf) {
        this(valueClass, conf, NetUtils.getDefaultSocketFactory(conf));
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        Hashtable<ConnectionId, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Deprecated
    public Writable call(Writable param, InetSocketAddress address) throws InterruptedException, IOException {
        return this.call(param, address, null);
    }

    @Deprecated
    public Writable call(Writable param, InetSocketAddress addr, UserGroupInformation ticket) throws InterruptedException, IOException {
        ConnectionId remoteId = ConnectionId.getConnectionId(addr, null, ticket, 0, this.conf);
        return this.call(param, remoteId);
    }

    @Deprecated
    public Writable call(Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket) throws InterruptedException, IOException {
        return this.call(param, addr, protocol, ticket, 0);
    }

    @Deprecated
    public Writable call(Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout) throws InterruptedException, IOException {
        ConnectionId remoteId = ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, this.conf);
        return this.call(param, remoteId);
    }

    @Deprecated
    public Writable call(Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, Configuration conf) throws InterruptedException, IOException {
        return this.call(param, addr, protocol, ticket, 0, conf);
    }

    @Deprecated
    public Writable call(Writable param, InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, Configuration conf) throws InterruptedException, IOException {
        ConnectionId remoteId = ConnectionId.getConnectionId(addr, protocol, ticket, rpcTimeout, conf);
        return this.call(param, remoteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable call(Writable param, ConnectionId remoteId) throws InterruptedException, IOException {
        Call call = new Call(param);
        Connection connection = this.getConnection(remoteId, call);
        try {
            connection.sendParam(call);
        }
        catch (RejectedExecutionException e) {
            throw new IOException("connection has been closed", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn((Object)"interrupted waiting to send params to server", (Throwable)e);
            throw new IOException(e);
        }
        boolean interrupted = false;
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                try {
                    call.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (call.error != null) {
                if (call.error instanceof RemoteException) {
                    call.error.fillInStackTrace();
                    throw call.error;
                }
                throw this.wrapException(remoteId.getAddress(), call.error);
            }
            return call.value;
        }
    }

    private IOException wrapException(InetSocketAddress addr, IOException exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed on socket timeout exception: " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    @Deprecated
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses) throws IOException, InterruptedException {
        return this.call(params, addresses, null, null, this.conf);
    }

    @Deprecated
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses, Class<?> protocol, UserGroupInformation ticket) throws IOException, InterruptedException {
        return this.call(params, addresses, protocol, ticket, this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writable[] call(Writable[] params, InetSocketAddress[] addresses, Class<?> protocol, UserGroupInformation ticket, Configuration conf) throws IOException, InterruptedException {
        ParallelResults results;
        if (addresses.length == 0) {
            return new Writable[0];
        }
        ParallelResults parallelResults = results = new ParallelResults(params.length);
        synchronized (parallelResults) {
            for (int i = 0; i < params.length; ++i) {
                ParallelCall call = new ParallelCall(params[i], results, i);
                try {
                    ConnectionId remoteId = ConnectionId.getConnectionId(addresses[i], protocol, ticket, 0, conf);
                    Connection connection = this.getConnection(remoteId, call);
                    connection.sendParam(call);
                    continue;
                }
                catch (RejectedExecutionException e) {
                    throw new IOException("connection has been closed", e);
                }
                catch (IOException e) {
                    LOG.info((Object)("Calling " + addresses[i] + " caught: " + e.getMessage()), (Throwable)e);
                    results.size--;
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn((Object)"interrupted waiting to send params to server", (Throwable)e);
                    throw new IOException(e);
                }
            }
            while (results.count != results.size) {
                try {
                    results.wait();
                }
                catch (InterruptedException e) {}
            }
            return results.values;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<ConnectionId> getConnectionIds() {
        Hashtable<ConnectionId, Connection> hashtable = this.connections;
        synchronized (hashtable) {
            return this.connections.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(ConnectionId remoteId, Call call) throws IOException, InterruptedException {
        Connection connection;
        if (!this.running.get()) {
            throw new IOException("The client is stopped");
        }
        do {
            Hashtable<ConnectionId, Connection> hashtable = this.connections;
            synchronized (hashtable) {
                connection = this.connections.get(remoteId);
                if (connection == null) {
                    connection = new Connection(remoteId);
                    this.connections.put(remoteId, connection);
                }
            }
        } while (!connection.addCall(call));
        connection.setupIOstreams();
        return connection;
    }

    static class ConnectionId {
        InetSocketAddress address;
        UserGroupInformation ticket;
        Class<?> protocol;
        private static final int PRIME = 16777619;
        private int rpcTimeout;
        private String serverPrincipal;
        private int maxIdleTime;
        private int maxRetries;
        private boolean tcpNoDelay;
        private boolean doPing;
        private int pingInterval;

        ConnectionId(InetSocketAddress address, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, String serverPrincipal, int maxIdleTime, int maxRetries, boolean tcpNoDelay, boolean doPing, int pingInterval) {
            this.protocol = protocol;
            this.address = address;
            this.ticket = ticket;
            this.rpcTimeout = rpcTimeout;
            this.serverPrincipal = serverPrincipal;
            this.maxIdleTime = maxIdleTime;
            this.maxRetries = maxRetries;
            this.tcpNoDelay = tcpNoDelay;
            this.doPing = doPing;
            this.pingInterval = pingInterval;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        Class<?> getProtocol() {
            return this.protocol;
        }

        UserGroupInformation getTicket() {
            return this.ticket;
        }

        private int getRpcTimeout() {
            return this.rpcTimeout;
        }

        String getServerPrincipal() {
            return this.serverPrincipal;
        }

        int getMaxIdleTime() {
            return this.maxIdleTime;
        }

        int getMaxRetries() {
            return this.maxRetries;
        }

        boolean getTcpNoDelay() {
            return this.tcpNoDelay;
        }

        boolean getDoPing() {
            return this.doPing;
        }

        int getPingInterval() {
            return this.pingInterval;
        }

        static ConnectionId getConnectionId(InetSocketAddress addr, Class<?> protocol, UserGroupInformation ticket, int rpcTimeout, Configuration conf) throws IOException {
            String remotePrincipal = ConnectionId.getRemotePrincipal(conf, addr, protocol);
            boolean doPing = conf.getBoolean("ipc.client.ping", true);
            return new ConnectionId(addr, protocol, ticket, rpcTimeout, remotePrincipal, conf.getInt("ipc.client.connection.maxidletime", 10000), conf.getInt("ipc.client.connect.max.retries", 10), conf.getBoolean("ipc.client.tcpnodelay", false), doPing, doPing ? Client.getPingInterval(conf) : 0);
        }

        private static String getRemotePrincipal(Configuration conf, InetSocketAddress address, Class<?> protocol) throws IOException {
            if (!UserGroupInformation.isSecurityEnabled() || protocol == null) {
                return null;
            }
            KerberosInfo krbInfo = protocol.getAnnotation(KerberosInfo.class);
            if (krbInfo != null) {
                String serverKey = krbInfo.serverPrincipal();
                if (serverKey == null) {
                    throw new IOException("Can't obtain server Kerberos config key from protocol=" + protocol.getCanonicalName());
                }
                return SecurityUtil.getServerPrincipal(conf.get(serverKey), address.getAddress());
            }
            return null;
        }

        static boolean isEqual(Object a, Object b) {
            return a == null ? b == null : a.equals(b);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ConnectionId) {
                ConnectionId that = (ConnectionId)obj;
                return ConnectionId.isEqual(this.address, that.address) && this.doPing == that.doPing && this.maxIdleTime == that.maxIdleTime && this.maxRetries == that.maxRetries && this.pingInterval == that.pingInterval && ConnectionId.isEqual(this.protocol, that.protocol) && ConnectionId.isEqual(this.serverPrincipal, that.serverPrincipal) && this.rpcTimeout == that.rpcTimeout && this.tcpNoDelay == that.tcpNoDelay && ConnectionId.isEqual(this.ticket, that.ticket);
            }
            return false;
        }

        public int hashCode() {
            int result = 1;
            result = 16777619 * result + (this.address == null ? 0 : this.address.hashCode());
            result = 16777619 * result + (this.doPing ? 1231 : 1237);
            result = 16777619 * result + this.maxIdleTime;
            result = 16777619 * result + this.maxRetries;
            result = 16777619 * result + this.pingInterval;
            result = 16777619 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            result = 16777619 * result + this.rpcTimeout;
            result = 16777619 * result + (this.serverPrincipal == null ? 0 : this.serverPrincipal.hashCode());
            result = 16777619 * result + (this.tcpNoDelay ? 1231 : 1237);
            result = 16777619 * result + (this.ticket == null ? 0 : this.ticket.hashCode());
            return result;
        }
    }

    private static class ParallelResults {
        private Writable[] values;
        private int size;
        private int count;

        public ParallelResults(int size) {
            this.values = new Writable[size];
            this.size = size;
        }

        public synchronized void callComplete(ParallelCall call) {
            this.values[((ParallelCall)call).index] = call.value;
            ++this.count;
            if (this.count == this.size) {
                this.notify();
            }
        }
    }

    private class ParallelCall
    extends Call {
        private ParallelResults results;
        private int index;

        public ParallelCall(Writable param, ParallelResults results, int index) {
            super(param);
            this.results = results;
            this.index = index;
        }

        @Override
        protected void callComplete() {
            this.results.callComplete(this);
        }
    }

    private class Connection
    extends Thread {
        private InetSocketAddress server;
        private String serverPrincipal;
        private ConnectionHeader header;
        private final ConnectionId remoteId;
        private SaslRpcServer.AuthMethod authMethod;
        private boolean useSasl;
        private Token<? extends TokenIdentifier> token;
        private SaslRpcClient saslRpcClient;
        private Socket socket = null;
        private DataInputStream in;
        private DataOutputStream out;
        private int rpcTimeout;
        private int maxIdleTime;
        private int maxRetries;
        private boolean tcpNoDelay;
        private boolean doPing;
        private int pingInterval;
        private Hashtable<Integer, Call> calls = new Hashtable();
        private AtomicLong lastActivity = new AtomicLong();
        private AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        private IOException closeException;
        private final Object sendParamsLock = new Object();

        public Connection(ConnectionId remoteId) throws IOException {
            this.remoteId = remoteId;
            this.server = remoteId.getAddress();
            if (this.server.isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            this.rpcTimeout = remoteId.getRpcTimeout();
            this.maxIdleTime = remoteId.getMaxIdleTime();
            this.maxRetries = remoteId.getMaxRetries();
            this.tcpNoDelay = remoteId.getTcpNoDelay();
            this.doPing = remoteId.getDoPing();
            this.pingInterval = remoteId.getPingInterval();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The ping interval is" + this.pingInterval + "ms."));
            }
            UserGroupInformation ticket = remoteId.getTicket();
            Class<?> protocol = remoteId.getProtocol();
            this.useSasl = UserGroupInformation.isSecurityEnabled();
            if (this.useSasl && protocol != null) {
                KerberosInfo krbInfo;
                TokenInfo tokenInfo = protocol.getAnnotation(TokenInfo.class);
                if (tokenInfo != null) {
                    TokenSelector<? extends TokenIdentifier> tokenSelector = null;
                    try {
                        tokenSelector = tokenInfo.value().newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IOException(e.toString());
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException(e.toString());
                    }
                    InetSocketAddress addr = remoteId.getAddress();
                    this.token = tokenSelector.selectToken(new Text(addr.getAddress().getHostAddress() + ":" + addr.getPort()), ticket.getTokens());
                }
                if ((krbInfo = protocol.getAnnotation(KerberosInfo.class)) != null) {
                    this.serverPrincipal = remoteId.getServerPrincipal();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RPC Server's Kerberos principal name for protocol=" + protocol.getCanonicalName() + " is " + this.serverPrincipal));
                    }
                }
            }
            this.authMethod = !this.useSasl ? SaslRpcServer.AuthMethod.SIMPLE : (this.token != null ? SaslRpcServer.AuthMethod.DIGEST : SaslRpcServer.AuthMethod.KERBEROS);
            this.header = new ConnectionHeader(protocol == null ? null : protocol.getName(), ticket, this.authMethod);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Use " + (Object)((Object)this.authMethod) + " authentication for protocol " + protocol.getSimpleName()));
            }
            this.setName("IPC Client (" + Client.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + " from " + (ticket == null ? "an unknown user" : ticket.getUserName()));
            this.setDaemon(true);
        }

        private void touch() {
            this.lastActivity.set(System.currentTimeMillis());
        }

        private synchronized boolean addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            this.calls.put(call.id, call);
            this.notify();
            return true;
        }

        private synchronized void disposeSasl() {
            if (this.saslRpcClient != null) {
                try {
                    this.saslRpcClient.dispose();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUser = currentUser.getRealUser();
            return this.authMethod == SaslRpcServer.AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals(currentUser) || loginUser.equals(realUser));
        }

        private synchronized boolean setupSaslConnection(InputStream in2, OutputStream out2) throws IOException {
            this.saslRpcClient = new SaslRpcClient(this.authMethod, this.token, this.serverPrincipal);
            return this.saslRpcClient.saslConnect(in2, out2);
        }

        private synchronized void setupConnection() throws IOException {
            int ioFailures = 0;
            int timeoutFailures = 0;
            while (true) {
                try {
                    this.socket = Client.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(this.tcpNoDelay);
                    NetUtils.connect(this.socket, this.remoteId.getAddress(), 20000);
                    if (this.rpcTimeout > 0) {
                        this.pingInterval = this.rpcTimeout;
                    }
                    this.socket.setSoTimeout(this.pingInterval);
                    return;
                }
                catch (SocketTimeoutException toe) {
                    int n = timeoutFailures;
                    timeoutFailures = (short)(timeoutFailures + 1);
                    this.handleConnectionFailure(n, 45, toe);
                    continue;
                }
                catch (IOException ie) {
                    int n = ioFailures;
                    ioFailures = (short)(ioFailures + 1);
                    this.handleConnectionFailure(n, this.maxRetries, ie);
                    continue;
                }
                break;
            }
        }

        private synchronized void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, final Random rand, UserGroupInformation ugi) throws IOException, InterruptedException {
            ugi.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    int maxBackoff = 5000;
                    Connection.this.closeConnection();
                    Connection.this.disposeSasl();
                    if (ex instanceof SocketTimeoutException) {
                        if (currRetries < maxRetries) {
                            LOG.warn((Object)("Encountered " + ex + " while trying to establish" + " SASL connection to the server. Will retry SASL connection" + " to server with principal " + Connection.this.serverPrincipal));
                            Thread.sleep(rand.nextInt(5000) + 1);
                            return null;
                        }
                        throw new IOException(ex);
                    }
                    if (Connection.this.shouldAuthenticateOverKrb()) {
                        if (currRetries < maxRetries) {
                            LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                            if (UserGroupInformation.isLoginKeytabBased()) {
                                UserGroupInformation.getLoginUser().reloginFromKeytab();
                            } else {
                                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                            }
                            Thread.sleep(rand.nextInt(5000) + 1);
                            return null;
                        }
                        String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + Connection.this.serverPrincipal;
                        LOG.warn((Object)msg);
                        throw (IOException)new IOException(msg).initCause(ex);
                    }
                    LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)ex;
                    }
                    throw new IOException(ex);
                }
            });
        }

        private synchronized void setupIOstreams() throws InterruptedException {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            try {
                OutputStream outStream;
                InputStream inStream;
                block13: {
                    boolean continueSasl;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connecting to " + this.server));
                    }
                    int numRetries = 0;
                    int maxRetries = 15;
                    Random rand = null;
                    while (true) {
                        this.setupConnection();
                        inStream = NetUtils.getInputStream(this.socket);
                        outStream = NetUtils.getOutputStream(this.socket);
                        this.writeRpcHeader(outStream);
                        if (!this.useSasl) break block13;
                        final InputStream in2 = inStream;
                        final OutputStream out2 = outStream;
                        UserGroupInformation ticket = this.remoteId.getTicket();
                        if (this.authMethod == SaslRpcServer.AuthMethod.KERBEROS && ticket.getRealUser() != null) {
                            ticket = ticket.getRealUser();
                        }
                        continueSasl = false;
                        try {
                            continueSasl = ticket.doAs(new PrivilegedExceptionAction<Boolean>(){

                                @Override
                                public Boolean run() throws IOException {
                                    return Connection.this.setupSaslConnection(in2, out2);
                                }
                            });
                        }
                        catch (Exception ex) {
                            if (rand == null) {
                                rand = new Random();
                            }
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, 15, ex, rand, ticket);
                            continue;
                        }
                        break;
                    }
                    if (continueSasl) {
                        inStream = this.saslRpcClient.getInputStream(inStream);
                        outStream = this.saslRpcClient.getOutputStream(outStream);
                    } else {
                        this.authMethod = SaslRpcServer.AuthMethod.SIMPLE;
                        this.header = new ConnectionHeader(this.header.getProtocol(), this.header.getUgi(), this.authMethod);
                        this.useSasl = false;
                    }
                }
                this.in = new DataInputStream(new BufferedInputStream(new PingInputStream(inStream)));
                this.out = new DataOutputStream(new BufferedOutputStream(outStream));
                this.writeHeader();
                this.touch();
                this.start();
                return;
            }
            catch (Throwable t) {
                if (t instanceof IOException) {
                    this.markClosed((IOException)t);
                } else {
                    this.markClosed(new IOException("Couldn't set up IO streams", t));
                }
                this.close();
                return;
            }
        }

        private void closeConnection() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close a socket", (Throwable)e);
                }
            }
            this.socket = null;
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            this.closeConnection();
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            LOG.info((Object)("Retrying connect to server: " + this.server + ". Already tried " + curRetries + " time(s)."));
        }

        private void writeRpcHeader(OutputStream outStream) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(outStream));
            out.write(Server.HEADER.array());
            out.write(4);
            this.authMethod.write(out);
            out.flush();
        }

        private void writeHeader() throws IOException {
            DataOutputBuffer buf = new DataOutputBuffer();
            this.header.write(buf);
            int bufLen = buf.getLength();
            this.out.writeInt(bufLen);
            this.out.write(buf.getData(), 0, bufLen);
        }

        private synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get() && (timeout = (long)this.maxIdleTime - (System.currentTimeMillis() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && Client.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sendPing() throws IOException {
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastActivity.get() >= (long)this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(-1);
                    this.out.flush();
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting, having connections " + Client.this.connections.size()));
            }
            try {
                while (this.waitForWork()) {
                    this.receiveResponse();
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)("Unexpected error reading responses on connection " + this), t);
                this.markClosed(new IOException("Error reading responses", t));
            }
            this.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": stopped, remaining connections " + Client.this.connections.size()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendParam(final Call call) throws InterruptedException {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            Object object = this.sendParamsLock;
            synchronized (object) {
                Future<?> senderFuture = SEND_PARAMS_EXECUTOR.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DataOutputBuffer d = null;
                        try {
                            DataOutputStream dataOutputStream = Connection.this.out;
                            synchronized (dataOutputStream) {
                                block11: {
                                    if (!Connection.this.shouldCloseConnection.get()) break block11;
                                    return;
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(Connection.this.getName() + " sending #" + call.id));
                                }
                                d = new DataOutputBuffer();
                                d.writeInt(call.id);
                                call.param.write(d);
                                byte[] data = d.getData();
                                int dataLength = d.getLength();
                                Connection.this.out.writeInt(dataLength);
                                Connection.this.out.write(data, 0, dataLength);
                                Connection.this.out.flush();
                            }
                            IOUtils.closeStream(d);
                        }
                        catch (IOException e) {
                            Connection.this.markClosed(e);
                        }
                        finally {
                            IOUtils.closeStream(d);
                        }
                    }
                });
                try {
                    senderFuture.get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException("checked exception made it here", cause);
                }
            }
        }

        private void receiveResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            try {
                int id = this.in.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + " got value #" + id));
                }
                Call call = this.calls.get(id);
                int state = this.in.readInt();
                if (state == Status.SUCCESS.state) {
                    Writable value = (Writable)ReflectionUtils.newInstance(Client.this.valueClass, Client.this.conf);
                    value.readFields(this.in);
                    call.setValue(value);
                    this.calls.remove(id);
                } else if (state == Status.ERROR.state) {
                    call.setException(new RemoteException(WritableUtils.readString(this.in), WritableUtils.readString(this.in)));
                    this.calls.remove(id);
                } else if (state == Status.FATAL.state) {
                    this.markClosed(new RemoteException(WritableUtils.readString(this.in), WritableUtils.readString(this.in)));
                }
            }
            catch (IOException e) {
                this.markClosed(e);
            }
        }

        private synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)"The connection is not in the closed state");
                return;
            }
            Hashtable hashtable = Client.this.connections;
            synchronized (hashtable) {
                if (Client.this.connections.get(this.remoteId) == this) {
                    Client.this.connections.remove(this.remoteId);
                }
            }
            IOUtils.closeStream(this.out);
            IOUtils.closeStream(this.in);
            this.disposeSasl();
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn((Object)"A connection is closed for no cause and calls are not empty");
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("closing ipc connection to " + this.server + ": " + this.closeException.getMessage()), (Throwable)this.closeException);
                }
                this.cleanupCalls();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closed"));
            }
        }

        private void cleanupCalls() {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                c.setException(this.closeException);
                itor.remove();
            }
        }

        private class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !Client.this.running.get() || Connection.this.rpcTimeout > 0) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private class Call {
        int id;
        Writable param;
        Writable value;
        IOException error;
        boolean done;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(Writable param) {
            this.param = param;
            Client client2 = Client.this;
            synchronized (client2) {
                this.id = Client.this.counter++;
            }
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public synchronized void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public synchronized void setValue(Writable value) {
            this.value = value;
            this.callComplete();
        }
    }
}

