/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSError;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.mapred.JVMId;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobLocalizer;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogsTruncater;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.server.tasktracker.JVMInfo;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.jvm.JvmMetrics;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.LogManager;

class Child {
    public static final Log LOG = LogFactory.getLog(Child.class);
    static volatile TaskAttemptID taskid = null;
    static volatile boolean currentJobSegmented = true;
    static volatile boolean isCleanup;
    static String cwd;
    private static boolean isChildJvm;

    Child() {
    }

    public static boolean isChildJvm() {
        return isChildJvm;
    }

    static boolean logIsSegmented(JobConf job) {
        return job.getNumTasksToExecutePerJvm() != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        LOG.debug((Object)"Child starting");
        isChildJvm = true;
        final JobConf defaultConf = new JobConf();
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        final InetSocketAddress address = new InetSocketAddress(host, port);
        TaskAttemptID firstTaskid = TaskAttemptID.forName(args[2]);
        final String logLocation = args[3];
        int SLEEP_LONGER_COUNT = 5;
        int jvmIdInt = Integer.parseInt(args[4]);
        JVMId jvmId = new JVMId(firstTaskid.getJobID(), firstTaskid.isMap(), jvmIdInt);
        cwd = System.getenv().get("HADOOP_WORK_DIR");
        if (cwd == null) {
            throw new IOException("Environment variable HADOOP_WORK_DIR is not set");
        }
        String jobTokenFile = System.getenv().get("HADOOP_TOKEN_FILE_LOCATION");
        Credentials credentials = TokenCache.loadTokens(jobTokenFile, defaultConf);
        LOG.debug((Object)("loading token. # keys =" + credentials.numberOfSecretKeys() + "; from file=" + jobTokenFile));
        Token<JobTokenIdentifier> jt = TokenCache.getJobToken(credentials);
        jt.setService(new Text(address.getAddress().getHostAddress() + ":" + address.getPort()));
        UserGroupInformation current = UserGroupInformation.getCurrentUser();
        current.addToken(jt);
        UserGroupInformation taskOwner = UserGroupInformation.createRemoteUser(firstTaskid.getJobID().toString());
        taskOwner.addToken(jt);
        defaultConf.setCredentials(credentials);
        final TaskUmbilicalProtocol umbilical = taskOwner.doAs(new PrivilegedExceptionAction<TaskUmbilicalProtocol>(){

            @Override
            public TaskUmbilicalProtocol run() throws Exception {
                return (TaskUmbilicalProtocol)RPC.getProxy(TaskUmbilicalProtocol.class, 18L, address, defaultConf);
            }
        });
        int numTasksToExecute = -1;
        int numTasksExecuted = 0;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    if (taskid != null) {
                        TaskLog.syncLogs(logLocation, taskid, isCleanup, currentJobSegmented);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                            if (taskid == null) continue;
                            TaskLog.syncLogs(logLocation, taskid, isCleanup, currentJobSegmented);
                        }
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    catch (IOException iee) {
                        LOG.error((Object)("Error in syncLogs: " + iee));
                        System.exit(-1);
                        continue;
                    }
                    break;
                }
            }
        };
        t.setName("Thread for syncLogs");
        t.setDaemon(true);
        t.start();
        String pid = "";
        if (!Shell.WINDOWS) {
            pid = System.getenv().get("JVM_PID");
        }
        JvmContext context = new JvmContext(jvmId, pid);
        int idleLoopCount = 0;
        Task task = null;
        UserGroupInformation childUGI = null;
        JvmContext jvmContext = context;
        try {
            while (true) {
                taskid = null;
                currentJobSegmented = true;
                JvmTask myTask = umbilical.getTask(context);
                if (myTask.shouldDie()) {
                    break;
                }
                if (myTask.getTask() == null) {
                    taskid = null;
                    currentJobSegmented = true;
                    if (++idleLoopCount >= 5) {
                        Thread.sleep(1500L);
                        continue;
                    }
                    Thread.sleep(500L);
                    continue;
                }
                idleLoopCount = 0;
                task = myTask.getTask();
                task.setJvmContext(jvmContext);
                taskid = task.getTaskID();
                final JobConf job = new JobConf(task.getJobFile());
                currentJobSegmented = Child.logIsSegmented(job);
                isCleanup = task.isTaskCleanupTask();
                FileSystem.clearStatistics();
                job.setCredentials(defaultConf.getCredentials());
                job.setBoolean("fs.file.impl.disable.cache", false);
                task.setJobTokenSecret(JobTokenSecretManager.createSecretKey(jt.getPassword()));
                TaskRunner.setupChildMapredLocalDirs(task, job);
                Child.localizeTask(task, job, logLocation);
                TaskRunner.setupWorkDir(job, new File(cwd));
                TaskLog.syncLogs(logLocation, taskid, isCleanup, Child.logIsSegmented(job));
                numTasksToExecute = job.getNumTasksToExecutePerJvm();
                assert (numTasksToExecute != 0);
                task.setConf(job);
                JvmMetrics.init(task.getPhase().toString(), job.getSessionId());
                LOG.debug((Object)("Creating remote user to execute task: " + job.get("user.name")));
                childUGI = UserGroupInformation.createRemoteUser(job.get("user.name"));
                for (Token<? extends TokenIdentifier> token : UserGroupInformation.getCurrentUser().getTokens()) {
                    childUGI.addToken(token);
                }
                final Task taskFinal = task;
                childUGI.doAs(new PrivilegedExceptionAction<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object run() throws Exception {
                        try {
                            FileSystem.get(job).setWorkingDirectory(job.getWorkingDirectory());
                            taskFinal.run(job, umbilical);
                        }
                        catch (Throwable throwable) {
                            TaskLog.syncLogs(logLocation, taskid, isCleanup, Child.logIsSegmented(job));
                            TaskLogsTruncater trunc = new TaskLogsTruncater(defaultConf);
                            trunc.truncateLogs(new JVMInfo(TaskLog.getAttemptDir(taskFinal.getTaskID(), taskFinal.isTaskCleanupTask()), Arrays.asList(taskFinal)));
                            throw throwable;
                        }
                        TaskLog.syncLogs(logLocation, taskid, isCleanup, Child.logIsSegmented(job));
                        TaskLogsTruncater trunc = new TaskLogsTruncater(defaultConf);
                        trunc.truncateLogs(new JVMInfo(TaskLog.getAttemptDir(taskFinal.getTaskID(), taskFinal.isTaskCleanupTask()), Arrays.asList(taskFinal)));
                        return null;
                    }
                });
                if (numTasksToExecute > 0 && ++numTasksExecuted == numTasksToExecute) break;
            }
        }
        catch (FSError e) {
            LOG.fatal((Object)"FSError from child", (Throwable)e);
            umbilical.fsError(taskid, e.getMessage(), jvmContext);
        }
        catch (Exception exception) {
            LOG.warn((Object)"Error running child", (Throwable)exception);
            try {
                if (task != null) {
                    if (childUGI == null) {
                        task.taskCleanup(umbilical);
                    } else {
                        final Task taskFinal = task;
                        childUGI.doAs(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                taskFinal.taskCleanup(umbilical);
                                return null;
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                LOG.info((Object)"Error cleaning up", (Throwable)e);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(baos));
            if (taskid != null) {
                umbilical.reportDiagnosticInfo(taskid, baos.toString(), jvmContext);
            }
        }
        catch (Throwable throwable) {
            LOG.fatal((Object)("Error running child : " + StringUtils.stringifyException(throwable)));
            if (taskid != null) {
                Throwable tCause = throwable.getCause();
                String cause = tCause == null ? throwable.getMessage() : StringUtils.stringifyException(tCause);
                umbilical.fatalError(taskid, cause, jvmContext);
            }
        }
        finally {
            RPC.stopProxy(umbilical);
            MetricsContext metricsContext = MetricsUtil.getContext("mapred");
            metricsContext.close();
            LogManager.shutdown();
        }
    }

    static void localizeTask(Task task, JobConf jobConf, String logLocation) throws IOException {
        task.localizeConfiguration(jobConf);
        LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapred.local.dir");
        Path localTaskFile = lDirAlloc.getLocalPathForWrite("job.xml", jobConf);
        JobLocalizer.writeLocalJobFile(localTaskFile, jobConf);
        task.setJobFile(localTaskFile.toString());
        task.setConf(jobConf);
    }

    static {
        isChildJvm = false;
    }
}

