/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.thirdparty.guava.common.base;

import org.apache.hadoop.thirdparty.guava.common.annotations.Beta;
import org.apache.hadoop.thirdparty.guava.common.annotations.GwtCompatible;
import org.apache.hadoop.thirdparty.guava.common.base.Function;
import org.apache.hadoop.thirdparty.guava.common.base.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@Beta
public final class Enums {
    private Enums() {
    }

    public static <T extends Enum<T>> Function<String, T> valueOfFunction(Class<T> enumClass) {
        return new ValueOfFunction(enumClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueOfFunction<T extends Enum<T>>
    implements Function<String, T> {
        private final Class<T> enumClass;

        private ValueOfFunction(Class<T> enumClass) {
            this.enumClass = Preconditions.checkNotNull(enumClass);
        }

        @Override
        public T apply(String value) {
            try {
                return Enum.valueOf(this.enumClass, value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

