/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.ExecDriver;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobConf;

public class MapRedTask
extends ExecDriver
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String HADOOP_MEM_KEY = "HADOOP_HEAPSIZE";
    static final String HADOOP_OPTS_KEY = "HADOOP_OPTS";
    static final String[] HIVE_SYS_PROP = new String[]{"build.dir", "build.dir.hive"};
    private transient ContentSummary inputSummary = null;
    private transient boolean runningViaChild = false;

    public MapRedTask() {
    }

    public MapRedTask(MapredWork plan, JobConf job, boolean isSilent) throws HiveException {
        throw new RuntimeException("Illegal Constructor call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        Context ctx = driverContext.getCtx();
        boolean ctxCreated = false;
        try {
            int numReducers;
            if (ctx == null) {
                ctx = new Context(this.conf);
                ctxCreated = true;
            }
            this.setNumberOfReducers();
            if (!ctx.isLocalOnlyExecutionMode() && this.conf.getBoolVar(HiveConf.ConfVars.LOCALMODEAUTO)) {
                String reason;
                if (this.inputSummary == null) {
                    this.inputSummary = Utilities.getInputSummary(driverContext.getCtx(), (MapredWork)this.work, null);
                }
                numReducers = ((MapredWork)this.work).getNumReduceTasks();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Task: " + this.getId() + ", Summary: " + this.inputSummary.getLength() + "," + this.inputSummary.getFileCount() + "," + numReducers));
                }
                if ((reason = MapRedTask.isEligibleForLocalMode(this.conf, this.inputSummary, numReducers)) == null) {
                    this.cloneConf();
                    this.conf.setVar(HiveConf.ConfVars.HADOOPJT, "local");
                    this.console.printInfo("Selecting local mode for task: " + this.getId());
                    this.setLocalMode(true);
                } else {
                    this.console.printInfo("Cannot run job locally: " + reason);
                    this.setLocalMode(false);
                }
            }
            boolean bl = this.runningViaChild = "local".equals(this.conf.getVar(HiveConf.ConfVars.HADOOPJT)) || this.conf.getBoolVar(HiveConf.ConfVars.SUBMITVIACHILD);
            if (!this.runningViaChild) {
                numReducers = super.execute(driverContext);
                return numReducers;
            }
            this.cloneConf();
            String hadoopExec = this.conf.getVar(HiveConf.ConfVars.HADOOPBIN);
            String hiveJar = this.conf.getJar();
            String addedJars = MapRedTask.getResourceFiles(this.conf, SessionState.ResourceType.JAR);
            this.conf.setVar(HiveConf.ConfVars.HIVEADDEDJARS, addedJars);
            String auxJars = this.conf.getAuxJars();
            String libJarsOption = StringUtils.isEmpty(addedJars) ? (StringUtils.isEmpty(auxJars) ? " " : " -libjars " + auxJars + " ") : (StringUtils.isEmpty(auxJars) ? " -libjars " + addedJars + " " : " -libjars " + addedJars + "," + auxJars + " ");
            String hiveConfArgs = MapRedTask.generateCmdLine(this.conf);
            Path planPath = new Path(ctx.getLocalTmpFileURI(), "plan.xml");
            FSDataOutputStream out = FileSystem.getLocal((Configuration)this.conf).create(planPath);
            MapredWork plan = (MapredWork)this.getWork();
            this.LOG.info((Object)("Generating plan file " + planPath.toString()));
            Utilities.serializeMapRedWork(plan, (OutputStream)out);
            String isSilent = "true".equalsIgnoreCase(System.getProperty("test.silent")) ? "-nolog" : "";
            String jarCmd = ShimLoader.getHadoopShims().usesJobShell() ? libJarsOption + hiveJar + " " + ExecDriver.class.getName() : hiveJar + " " + ExecDriver.class.getName() + libJarsOption;
            String cmdLine = hadoopExec + " jar " + jarCmd + " -plan " + planPath.toString() + " " + isSilent + " " + hiveConfArgs;
            String workDir = new File(".").getCanonicalPath();
            String files = MapRedTask.getResourceFiles(this.conf, SessionState.ResourceType.FILE);
            if (!files.isEmpty()) {
                cmdLine = cmdLine + " -files " + files;
                workDir = new Path(ctx.getLocalTmpFileURI()).toUri().getPath();
                if (!new File(workDir).mkdir()) {
                    throw new IOException("Cannot create tmp working dir: " + workDir);
                }
                for (String f : StringUtils.split(files, ',')) {
                    String link;
                    Path p = new Path(f);
                    String target = p.toUri().getPath();
                    if (FileUtil.symLink((String)target, (String)(link = workDir + "/" + p.getName())) == 0) continue;
                    throw new IOException("Cannot link to added file: " + target + " from: " + link);
                }
            }
            this.LOG.info((Object)("Executing: " + cmdLine));
            Process executor = null;
            StringBuilder sb = new StringBuilder();
            Properties p = System.getProperties();
            for (String element : HIVE_SYS_PROP) {
                if (!p.containsKey(element)) continue;
                sb.append(" -D" + element + "=" + p.getProperty(element));
            }
            String hadoopOpts = sb.toString();
            HashMap<String, String> variables = new HashMap<String, String>(System.getenv());
            if ("local".equals(this.conf.getVar(HiveConf.ConfVars.HADOOPJT))) {
                int hadoopMem = this.conf.getIntVar(HiveConf.ConfVars.HIVEHADOOPMAXMEM);
                if (hadoopMem == 0) {
                    variables.remove(HADOOP_MEM_KEY);
                } else {
                    variables.put(HADOOP_MEM_KEY, String.valueOf(hadoopMem));
                }
            }
            if (variables.containsKey(HADOOP_OPTS_KEY)) {
                variables.put(HADOOP_OPTS_KEY, (String)variables.get(HADOOP_OPTS_KEY) + hadoopOpts);
            } else {
                variables.put(HADOOP_OPTS_KEY, hadoopOpts);
            }
            String[] env = new String[variables.size()];
            int pos = 0;
            for (Map.Entry entry : variables.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                env[pos++] = name + "=" + value;
            }
            executor = Runtime.getRuntime().exec(cmdLine, env, new File(workDir));
            Utilities.StreamPrinter outPrinter = new Utilities.StreamPrinter(executor.getInputStream(), null, SessionState.getConsole().getChildOutStream());
            Utilities.StreamPrinter errPrinter = new Utilities.StreamPrinter(executor.getErrorStream(), null, SessionState.getConsole().getChildErrStream());
            outPrinter.start();
            errPrinter.start();
            int exitVal = executor.waitFor();
            if (exitVal != 0) {
                this.LOG.error((Object)("Execution failed with exit status: " + exitVal));
            } else {
                this.LOG.info((Object)"Execution completed successfully");
            }
            int n = exitVal;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.LOG.error((Object)("Exception: " + e.getMessage()));
            int n = 1;
            return n;
        }
        finally {
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)("Exception: " + e.getMessage()));
            }
        }
    }

    @Override
    public boolean mapStarted() {
        boolean b = super.mapStarted();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean reduceStarted() {
        boolean b = super.reduceStarted();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean mapDone() {
        boolean b = super.mapDone();
        return this.runningViaChild ? this.isdone : b;
    }

    @Override
    public boolean reduceDone() {
        boolean b = super.reduceDone();
        return this.runningViaChild ? this.isdone : b;
    }

    private void setNumberOfReducers() throws IOException {
        Integer numReducersFromWork = ((MapredWork)this.work).getNumReduceTasks();
        if (((MapredWork)this.work).getReducer() == null) {
            this.console.printInfo("Number of reduce tasks is set to 0 since there's no reduce operator");
            ((MapredWork)this.work).setNumReduceTasks(0);
        } else {
            if (numReducersFromWork >= 0) {
                this.console.printInfo("Number of reduce tasks determined at compile time: " + ((MapredWork)this.work).getNumReduceTasks());
            } else if (this.job.getNumReduceTasks() > 0) {
                int reducers = this.job.getNumReduceTasks();
                ((MapredWork)this.work).setNumReduceTasks(reducers);
                this.console.printInfo("Number of reduce tasks not specified. Defaulting to jobconf value of: " + reducers);
            } else {
                int reducers = this.estimateNumberOfReducers();
                ((MapredWork)this.work).setNumReduceTasks(reducers);
                this.console.printInfo("Number of reduce tasks not specified. Estimated from input data size: " + reducers);
            }
            this.console.printInfo("In order to change the average load for a reducer (in bytes):");
            this.console.printInfo("  set " + HiveConf.ConfVars.BYTESPERREDUCER.varname + "=<number>");
            this.console.printInfo("In order to limit the maximum number of reducers:");
            this.console.printInfo("  set " + HiveConf.ConfVars.MAXREDUCERS.varname + "=<number>");
            this.console.printInfo("In order to set a constant number of reducers:");
            this.console.printInfo("  set " + (Object)((Object)HiveConf.ConfVars.HADOOPNUMREDUCERS) + "=<number>");
        }
    }

    private int estimateNumberOfReducers() throws IOException {
        long bytesPerReducer = this.conf.getLongVar(HiveConf.ConfVars.BYTESPERREDUCER);
        int maxReducers = this.conf.getIntVar(HiveConf.ConfVars.MAXREDUCERS);
        if (this.inputSummary == null) {
            this.inputSummary = Utilities.getInputSummary(this.driverContext.getCtx(), (MapredWork)this.work, null);
        }
        long totalInputFileSize = this.inputSummary.getLength();
        this.LOG.info((Object)("BytesPerReducer=" + bytesPerReducer + " maxReducers=" + maxReducers + " totalInputFileSize=" + totalInputFileSize));
        int reducers = (int)((totalInputFileSize + bytesPerReducer - 1L) / bytesPerReducer);
        reducers = Math.max(1, reducers);
        reducers = Math.min(maxReducers, reducers);
        return reducers;
    }

    public static String isEligibleForLocalMode(HiveConf conf, ContentSummary inputSummary, int numReducers) {
        long maxBytes = conf.getLongVar(HiveConf.ConfVars.LOCALMODEMAXBYTES);
        long maxTasks = conf.getIntVar(HiveConf.ConfVars.LOCALMODEMAXTASKS);
        if (inputSummary.getLength() > maxBytes) {
            return "Input Size (= " + inputSummary.getLength() + ") is larger than " + HiveConf.ConfVars.LOCALMODEMAXBYTES.varname + " (= " + maxBytes + ")";
        }
        if (inputSummary.getFileCount() > maxTasks) {
            return "Number of Input Files (= " + inputSummary.getFileCount() + ") is larger than " + HiveConf.ConfVars.LOCALMODEMAXTASKS.varname + "(= " + maxTasks + ")";
        }
        if (numReducers > 1) {
            return "Number of reducers (= " + numReducers + ") is more than 1";
        }
        return null;
    }
}

