/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector.primitive;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyInteger;
import org.apache.hadoop.hive.serde2.lazy.LazyLong;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public final class PrimitiveObjectInspectorUtils {
    static final Map<PrimitiveObjectInspector.PrimitiveCategory, PrimitiveTypeEntry> primitiveCategoryToTypeEntry = new HashMap<PrimitiveObjectInspector.PrimitiveCategory, PrimitiveTypeEntry>();
    static final Map<Class<?>, PrimitiveTypeEntry> primitiveJavaTypeToTypeEntry = new HashMap();
    static final Map<Class<?>, PrimitiveTypeEntry> primitiveJavaClassToTypeEntry = new HashMap();
    static final Map<Class<?>, PrimitiveTypeEntry> primitiveWritableClassToTypeEntry = new HashMap();
    static final Map<String, PrimitiveTypeEntry> typeNameToTypeEntry = new HashMap<String, PrimitiveTypeEntry>();
    public static final PrimitiveTypeEntry stringTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.STRING, "string", null, String.class, Text.class);
    public static final PrimitiveTypeEntry booleanTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN, "boolean", Boolean.TYPE, Boolean.class, BooleanWritable.class);
    public static final PrimitiveTypeEntry intTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.INT, "int", Integer.TYPE, Integer.class, IntWritable.class);
    public static final PrimitiveTypeEntry longTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.LONG, "bigint", Long.TYPE, Long.class, LongWritable.class);
    public static final PrimitiveTypeEntry floatTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.FLOAT, "float", Float.TYPE, Float.class, FloatWritable.class);
    public static final PrimitiveTypeEntry voidTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.VOID, "void", Void.TYPE, Void.class, NullWritable.class);
    public static final PrimitiveTypeEntry doubleTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE, "double", Double.TYPE, Double.class, DoubleWritable.class);
    public static final PrimitiveTypeEntry byteTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.BYTE, "tinyint", Byte.TYPE, Byte.class, ByteWritable.class);
    public static final PrimitiveTypeEntry shortTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.SHORT, "smallint", Short.TYPE, Short.class, ShortWritable.class);
    public static final PrimitiveTypeEntry unknownTypeEntry = new PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN, "unknown", null, Object.class, null);

    static void registerType(PrimitiveTypeEntry t) {
        if (t.primitiveCategory != PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN) {
            primitiveCategoryToTypeEntry.put(t.primitiveCategory, t);
        }
        if (t.primitiveJavaType != null) {
            primitiveJavaTypeToTypeEntry.put(t.primitiveJavaType, t);
        }
        if (t.primitiveJavaClass != null) {
            primitiveJavaClassToTypeEntry.put(t.primitiveJavaClass, t);
        }
        if (t.primitiveWritableClass != null) {
            primitiveWritableClassToTypeEntry.put(t.primitiveWritableClass, t);
        }
        if (t.typeName != null) {
            typeNameToTypeEntry.put(t.typeName, t);
        }
    }

    public static Class<?> primitiveJavaTypeToClass(Class<?> clazz) {
        PrimitiveTypeEntry t = primitiveJavaTypeToTypeEntry.get(clazz);
        return t == null ? clazz : t.primitiveJavaClass;
    }

    public static boolean isPrimitiveJava(Class<?> clazz) {
        return primitiveJavaTypeToTypeEntry.get(clazz) != null || primitiveJavaClassToTypeEntry.get(clazz) != null;
    }

    public static boolean isPrimitiveJavaType(Class<?> clazz) {
        return primitiveJavaTypeToTypeEntry.get(clazz) != null;
    }

    public static boolean isPrimitiveJavaClass(Class<?> clazz) {
        return primitiveJavaClassToTypeEntry.get(clazz) != null;
    }

    public static boolean isPrimitiveWritableClass(Class<?> clazz) {
        return primitiveWritableClassToTypeEntry.get(clazz) != null;
    }

    public static String getTypeNameFromPrimitiveJava(Class<?> clazz) {
        PrimitiveTypeEntry t = primitiveJavaTypeToTypeEntry.get(clazz);
        if (t == null) {
            t = primitiveJavaClassToTypeEntry.get(clazz);
        }
        return t == null ? null : t.typeName;
    }

    public static String getTypeNameFromPrimitiveWritable(Class<?> clazz) {
        PrimitiveTypeEntry t = primitiveWritableClassToTypeEntry.get(clazz);
        return t == null ? null : t.typeName;
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveCategory(PrimitiveObjectInspector.PrimitiveCategory category) {
        return primitiveCategoryToTypeEntry.get((Object)category);
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveJava(Class<?> clazz) {
        PrimitiveTypeEntry t = primitiveJavaTypeToTypeEntry.get(clazz);
        if (t == null) {
            t = primitiveJavaClassToTypeEntry.get(clazz);
        }
        return t;
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveJavaType(Class<?> clazz) {
        return primitiveJavaTypeToTypeEntry.get(clazz);
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveJavaClass(Class<?> clazz) {
        return primitiveJavaClassToTypeEntry.get(clazz);
    }

    public static PrimitiveTypeEntry getTypeEntryFromPrimitiveWritableClass(Class<?> clazz) {
        return primitiveWritableClassToTypeEntry.get(clazz);
    }

    public static PrimitiveTypeEntry getTypeEntryFromTypeName(String typeName) {
        return typeNameToTypeEntry.get(typeName);
    }

    public static boolean comparePrimitiveObjects(Object o1, PrimitiveObjectInspector oi1, Object o2, PrimitiveObjectInspector oi2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (oi1.getPrimitiveCategory() != oi2.getPrimitiveCategory()) {
            return false;
        }
        switch (oi1.getPrimitiveCategory()) {
            case BOOLEAN: {
                return ((BooleanObjectInspector)oi1).get(o1) == ((BooleanObjectInspector)oi2).get(o2);
            }
            case BYTE: {
                return ((ByteObjectInspector)oi1).get(o1) == ((ByteObjectInspector)oi2).get(o2);
            }
            case SHORT: {
                return ((ShortObjectInspector)oi1).get(o1) == ((ShortObjectInspector)oi2).get(o2);
            }
            case INT: {
                return ((IntObjectInspector)oi1).get(o1) == ((IntObjectInspector)oi2).get(o2);
            }
            case LONG: {
                return ((LongObjectInspector)oi1).get(o1) == ((LongObjectInspector)oi2).get(o2);
            }
            case FLOAT: {
                return ((FloatObjectInspector)oi1).get(o1) == ((FloatObjectInspector)oi2).get(o2);
            }
            case DOUBLE: {
                return ((DoubleObjectInspector)oi1).get(o1) == ((DoubleObjectInspector)oi2).get(o2);
            }
            case STRING: {
                Text t1 = ((StringObjectInspector)oi1).getPrimitiveWritableObject(o1);
                Text t2 = ((StringObjectInspector)oi2).getPrimitiveWritableObject(o2);
                return t1.equals(t2);
            }
        }
        return false;
    }

    public static double convertPrimitiveToDouble(Object o, PrimitiveObjectInspector oi) {
        switch (oi.getPrimitiveCategory()) {
            case BOOLEAN: {
                return ((BooleanObjectInspector)oi).get(o) ? 1.0 : 0.0;
            }
            case BYTE: {
                return ((ByteObjectInspector)oi).get(o);
            }
            case SHORT: {
                return ((ShortObjectInspector)oi).get(o);
            }
            case INT: {
                return ((IntObjectInspector)oi).get(o);
            }
            case LONG: {
                return ((LongObjectInspector)oi).get(o);
            }
            case FLOAT: {
                return ((FloatObjectInspector)oi).get(o);
            }
            case DOUBLE: {
                return ((DoubleObjectInspector)oi).get(o);
            }
            case STRING: {
                return Double.valueOf(((StringObjectInspector)oi).getPrimitiveJavaObject(o));
            }
        }
        throw new NumberFormatException();
    }

    public static boolean comparePrimitiveObjectsWithConversion(Object o1, PrimitiveObjectInspector oi1, Object o2, PrimitiveObjectInspector oi2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (oi1.getPrimitiveCategory() == oi2.getPrimitiveCategory()) {
            return PrimitiveObjectInspectorUtils.comparePrimitiveObjects(o1, oi1, o2, oi2);
        }
        try {
            return PrimitiveObjectInspectorUtils.convertPrimitiveToDouble(o1, oi1) == PrimitiveObjectInspectorUtils.convertPrimitiveToDouble(o2, oi2);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean getBoolean(Object o, PrimitiveObjectInspector oi) {
        boolean result = false;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = false;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o);
                break;
            }
            case BYTE: {
                result = ((ByteObjectInspector)oi).get(o) != 0;
                break;
            }
            case SHORT: {
                result = ((ShortObjectInspector)oi).get(o) != 0;
                break;
            }
            case INT: {
                result = ((IntObjectInspector)oi).get(o) != 0;
                break;
            }
            case LONG: {
                result = (int)((LongObjectInspector)oi).get(o) != 0;
                break;
            }
            case FLOAT: {
                result = (int)((FloatObjectInspector)oi).get(o) != 0;
                break;
            }
            case DOUBLE: {
                result = (int)((DoubleObjectInspector)oi).get(o) != 0;
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                if (soi.preferWritable()) {
                    Text t = soi.getPrimitiveWritableObject(o);
                    result = t.getLength() != 0;
                    break;
                }
                String s = soi.getPrimitiveJavaObject(o);
                result = s.length() != 0;
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unknown type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static byte getByte(Object o, PrimitiveObjectInspector oi) {
        return (byte)PrimitiveObjectInspectorUtils.getInt(o, oi);
    }

    public static short getShort(Object o, PrimitiveObjectInspector oi) {
        return (short)PrimitiveObjectInspectorUtils.getInt(o, oi);
    }

    public static int getInt(Object o, PrimitiveObjectInspector oi) {
        int result = 0;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = 0;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o) ? 1 : 0;
                break;
            }
            case BYTE: {
                result = ((ByteObjectInspector)oi).get(o);
                break;
            }
            case SHORT: {
                result = ((ShortObjectInspector)oi).get(o);
                break;
            }
            case INT: {
                result = ((IntObjectInspector)oi).get(o);
                break;
            }
            case LONG: {
                result = (int)((LongObjectInspector)oi).get(o);
                break;
            }
            case FLOAT: {
                result = (int)((FloatObjectInspector)oi).get(o);
                break;
            }
            case DOUBLE: {
                result = (int)((DoubleObjectInspector)oi).get(o);
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                if (soi.preferWritable()) {
                    Text t = soi.getPrimitiveWritableObject(o);
                    result = LazyInteger.parseInt(t.getBytes(), 0, t.getLength());
                    break;
                }
                String s = soi.getPrimitiveJavaObject(o);
                result = Integer.parseInt(s);
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unknown type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static long getLong(Object o, PrimitiveObjectInspector oi) {
        long result = 0L;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = 0L;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o) ? 1 : 0;
                break;
            }
            case BYTE: {
                result = ((ByteObjectInspector)oi).get(o);
                break;
            }
            case SHORT: {
                result = ((ShortObjectInspector)oi).get(o);
                break;
            }
            case INT: {
                result = ((IntObjectInspector)oi).get(o);
                break;
            }
            case LONG: {
                result = ((LongObjectInspector)oi).get(o);
                break;
            }
            case FLOAT: {
                result = (long)((FloatObjectInspector)oi).get(o);
                break;
            }
            case DOUBLE: {
                result = (long)((DoubleObjectInspector)oi).get(o);
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                if (soi.preferWritable()) {
                    Text t = soi.getPrimitiveWritableObject(o);
                    result = LazyLong.parseLong(t.getBytes(), 0, t.getLength());
                    break;
                }
                String s = soi.getPrimitiveJavaObject(o);
                result = Long.parseLong(s);
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unknown type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static double getDouble(Object o, PrimitiveObjectInspector oi) {
        double result = 0.0;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = 0.0;
                break;
            }
            case BOOLEAN: {
                result = ((BooleanObjectInspector)oi).get(o) ? 1 : 0;
                break;
            }
            case BYTE: {
                result = ((ByteObjectInspector)oi).get(o);
                break;
            }
            case SHORT: {
                result = ((ShortObjectInspector)oi).get(o);
                break;
            }
            case INT: {
                result = ((IntObjectInspector)oi).get(o);
                break;
            }
            case LONG: {
                result = ((LongObjectInspector)oi).get(o);
                break;
            }
            case FLOAT: {
                result = ((FloatObjectInspector)oi).get(o);
                break;
            }
            case DOUBLE: {
                result = ((DoubleObjectInspector)oi).get(o);
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                String s = soi.getPrimitiveJavaObject(o);
                result = Double.parseDouble(s);
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unknown type: " + oi.getTypeName());
            }
        }
        return result;
    }

    public static float getFloat(Object o, PrimitiveObjectInspector oi) {
        return (float)PrimitiveObjectInspectorUtils.getDouble(o, oi);
    }

    public static String getString(Object o, PrimitiveObjectInspector oi) {
        if (o == null) {
            return null;
        }
        String result = null;
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                result = null;
                break;
            }
            case BOOLEAN: {
                result = String.valueOf(((BooleanObjectInspector)oi).get(o));
                break;
            }
            case BYTE: {
                result = String.valueOf(((ByteObjectInspector)oi).get(o));
                break;
            }
            case SHORT: {
                result = String.valueOf(((ShortObjectInspector)oi).get(o));
                break;
            }
            case INT: {
                result = String.valueOf(((IntObjectInspector)oi).get(o));
                break;
            }
            case LONG: {
                result = String.valueOf(((LongObjectInspector)oi).get(o));
                break;
            }
            case FLOAT: {
                result = String.valueOf(((FloatObjectInspector)oi).get(o));
                break;
            }
            case DOUBLE: {
                result = String.valueOf(((DoubleObjectInspector)oi).get(o));
                break;
            }
            case STRING: {
                StringObjectInspector soi = (StringObjectInspector)oi;
                result = soi.getPrimitiveJavaObject(o);
                break;
            }
            default: {
                throw new RuntimeException("Hive 2 Internal error: unknown type: " + oi.getTypeName());
            }
        }
        return result;
    }

    private PrimitiveObjectInspectorUtils() {
    }

    static {
        PrimitiveObjectInspectorUtils.registerType(stringTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(booleanTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(intTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(longTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(floatTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(voidTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(doubleTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(byteTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(shortTypeEntry);
        PrimitiveObjectInspectorUtils.registerType(unknownTypeEntry);
    }

    public static class PrimitiveTypeEntry
    implements Writable {
        public PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        public Class<?> primitiveJavaType;
        public Class<?> primitiveJavaClass;
        public Class<?> primitiveWritableClass;
        public String typeName;

        PrimitiveTypeEntry(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, String typeName, Class<?> primitiveType, Class<?> javaClass, Class<?> hiveClass) {
            this.primitiveCategory = primitiveCategory;
            this.primitiveJavaType = primitiveType;
            this.primitiveJavaClass = javaClass;
            this.primitiveWritableClass = hiveClass;
            this.typeName = typeName;
        }

        public void readFields(DataInput in) throws IOException {
            this.primitiveCategory = (PrimitiveObjectInspector.PrimitiveCategory)WritableUtils.readEnum((DataInput)in, PrimitiveObjectInspector.PrimitiveCategory.class);
            this.typeName = WritableUtils.readString((DataInput)in);
            try {
                this.primitiveJavaType = Class.forName(WritableUtils.readString((DataInput)in));
                this.primitiveJavaClass = Class.forName(WritableUtils.readString((DataInput)in));
                this.primitiveWritableClass = Class.forName(WritableUtils.readString((DataInput)in));
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeEnum((DataOutput)out, (Enum)this.primitiveCategory);
            WritableUtils.writeString((DataOutput)out, (String)this.typeName);
            WritableUtils.writeString((DataOutput)out, (String)this.primitiveJavaType.getName());
            WritableUtils.writeString((DataOutput)out, (String)this.primitiveJavaClass.getName());
            WritableUtils.writeString((DataOutput)out, (String)this.primitiveWritableClass.getName());
        }
    }
}

