/**
 * Copyright (C) 2007-2012 Hypertable, Inc.
 *
 * This file is part of Hypertable.
 *
 * Hypertable is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or any later version.
 *
 * Hypertable is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef HYPERTABLE_REACTORRUNNER_H
#define HYPERTABLE_REACTORRUNNER_H

#include "HandlerMap.h"
#include "Reactor.h"

namespace Hypertable {

  class IOHandler;

  /**
   *
   */
  class ReactorRunner {
  public:
    void operator()();
    void set_reactor(ReactorPtr &reactor_ptr) { m_reactor_ptr = reactor_ptr; }
    static bool shutdown;
    static bool record_arrival_time;
    static HandlerMapPtr handler_map;
  private:
    void cleanup_and_remove_handlers(std::set<IOHandler *> &handlers);
    ReactorPtr m_reactor_ptr;
  };

}

#endif // HYPERTABLE_REACTORRUNNER_H
